/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.compat.CuriosCompat;
import de.melanx.skyblockbuilder.util.SkyPaths;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class StartingInventory {
    private static final List<org.apache.commons.lang3.tuple.Pair<EquipmentSlot, ItemStack>> STARTER_ITEMS = new ArrayList<org.apache.commons.lang3.tuple.Pair<EquipmentSlot, ItemStack>>();

    private StartingInventory() {
    }

    public static void loadStarterItems(RegistryAccess registryAccess) {
        STARTER_ITEMS.clear();
        File startInventoryConfig = new File(SkyPaths.ITEMS_FILE.toUri());
        RegistryOps registryOps = registryAccess.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        try {
            String s = IOUtils.toString((Reader)new InputStreamReader(new FileInputStream(startInventoryConfig)));
            JsonObject json = GsonHelper.parse((String)s, (boolean)true);
            if (json.has("items")) {
                JsonArray items = json.getAsJsonArray("items");
                HashSet<EquipmentSlot> usedTypes = new HashSet<EquipmentSlot>();
                int slotsUsedInMainInventory = 0;
                for (JsonElement element : items) {
                    EquipmentSlot slot;
                    JsonObject mainObject = element.getAsJsonObject();
                    Optional item = ItemStack.CODEC.decode((DynamicOps)registryOps, (Object)mainObject.get("Item")).resultOrPartial(arg_0 -> ((Logger)SkyblockBuilder.getLogger()).error(arg_0));
                    if (item.isEmpty()) {
                        throw new IllegalStateException("Unable to read starting item: " + String.valueOf(mainObject.get("Item")));
                    }
                    EquipmentSlot equipmentSlot = slot = mainObject.has("Slot") ? EquipmentSlot.byName((String)GsonHelper.getAsString((JsonObject)mainObject, (String)"Slot")) : EquipmentSlot.MAINHAND;
                    if (slot == EquipmentSlot.MAINHAND) {
                        if (slotsUsedInMainInventory >= 36) {
                            throw new IllegalStateException("Too many starting items in main inventory. Not more than 36 are allowed.");
                        }
                        ++slotsUsedInMainInventory;
                    } else {
                        if (usedTypes.contains(slot)) {
                            throw new IllegalStateException("Slot type that is not 'mainhand' was used multiple times for starting inventory.");
                        }
                        usedTypes.add(slot);
                    }
                    STARTER_ITEMS.add((org.apache.commons.lang3.tuple.Pair<EquipmentSlot, ItemStack>)org.apache.commons.lang3.tuple.Pair.of((Object)slot, (Object)((ItemStack)((Pair)item.get()).getFirst())));
                }
            }
            if (ModList.get().isLoaded("curios") && json.has("curios_items")) {
                CuriosCompat.loadStarterInventory(json.getAsJsonArray("curios_items"), (HolderLookup.Provider)registryAccess);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read starting inventory", e);
        }
    }

    public static List<org.apache.commons.lang3.tuple.Pair<EquipmentSlot, ItemStack>> getStarterItems() {
        return ImmutableList.copyOf(STARTER_ITEMS);
    }
}

