/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import de.melanx.skyblockbuilder.ModBlocks;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.compat.CuriosCompat;
import de.melanx.skyblockbuilder.config.StartingInventory;
import de.melanx.skyblockbuilder.config.common.CustomizationConfig;
import de.melanx.skyblockbuilder.config.common.TemplatesConfig;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.util.WorldUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.fml.ModList;
import org.moddingx.libx.annotation.meta.RemoveIn;

public class RandomUtility {
    public static JsonObject serializeItem(ItemStack stack) {
        JsonObject json = new JsonObject();
        CompoundTag tag = stack.serializeNBT();
        json.addProperty("item", tag.m_128461_("id"));
        int count = tag.m_128451_("Count");
        if (count > 1) {
            json.addProperty("count", (Number)count);
        }
        if (tag.m_128441_("tag")) {
            json.addProperty("nbt", tag.m_128423_("tag").toString());
        }
        if (tag.m_128441_("ForgeCaps")) {
            json.addProperty("ForgeCaps", tag.m_128423_("ForgeCaps").toString());
        }
        return json;
    }

    public static void dropInventories(Player player) {
        if (player.m_5833_() || player.m_7500_()) {
            return;
        }
        player.m_150109_().m_36071_();
        if (ModList.get().isLoaded("curios")) {
            CuriosCompat.dropInventory(player);
        }
    }

    public static void setStartInventory(ServerPlayer player) {
        if (player.m_5833_() || player.m_7500_()) {
            return;
        }
        StartingInventory.getStarterItems().forEach(entry -> {
            if (entry.getLeft() == EquipmentSlot.MAINHAND) {
                player.m_150109_().m_36054_(((ItemStack)entry.getRight()).m_41777_());
            } else {
                player.m_8061_((EquipmentSlot)entry.getLeft(), ((ItemStack)entry.getRight()).m_41777_());
            }
        });
        if (ModList.get().isLoaded("curios")) {
            CuriosCompat.setStartInventory((Player)player);
        }
    }

    public static Component getFormattedPos(BlockPos pos) {
        return ComponentUtils.m_130748_((Component)Component.m_237110_((String)"chat.coordinates", (Object[])new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}).m_130938_(style -> style.m_131140_(ChatFormatting.GREEN).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"chat.coordinates.tooltip")))));
    }

    public static String formattedCooldown(long ticks) {
        int realTime = (int)(ticks / 20L);
        int min = realTime / 60;
        String sec = String.format("%02d", realTime % 60);
        return String.format("%s:%s", min, sec);
    }

    public static void deleteTeamIfEmpty(SkyblockSavedData data, Team team) {
        if (team.isEmpty() && CustomizationConfig.deleteTeamsAutomatically) {
            data.deleteTeam(team.getId());
            SkyblockBuilder.getLogger().info("Team {} ({}) was deleted. No player left.", (Object)team.getName(), (Object)team.getId());
        }
    }

    public static Set<GameProfile> getGameProfiles(ServerLevel level) {
        MinecraftServer server = level.m_7654_();
        GameProfileCache profileCache = server.m_129927_();
        Set profiles = Sets.newConcurrentHashSet();
        Set handledIds = Sets.newConcurrentHashSet();
        handledIds.add(Util.f_137441_);
        profileCache.m_10976_().forEach(profileInfo -> {
            GameProfile profile = profileInfo.m_11028_();
            profiles.add(profile);
            handledIds.add(profile.getId());
        });
        int cachedProfilesAmount = profiles.size() - 1;
        int usedCachedProfilesAmount = 0;
        int uncachedProfilesAmount = 0;
        int totalProfilesAmount = 0;
        for (Team team : SkyblockSavedData.get((Level)level).getTeams()) {
            for (UUID id : team.getPlayers()) {
                GameProfile profile;
                ++totalProfilesAmount;
                if (handledIds.contains(id)) {
                    ++usedCachedProfilesAmount;
                    continue;
                }
                if (UsernameCache.containsUUID((UUID)id)) {
                    String lastKnownUsername = UsernameCache.getLastKnownUsername((UUID)id);
                    profiles.add(new GameProfile(id, lastKnownUsername));
                    continue;
                }
                ++uncachedProfilesAmount;
                Optional gameProfile = profileCache.m_11002_(id);
                if (gameProfile.isPresent()) {
                    profiles.add((GameProfile)gameProfile.get());
                    continue;
                }
                GameProfile unnamedProfile = new GameProfile(id, null);
                boolean enforceProfileSecurity = CustomizationConfig.forceUnsecureProfileNames || level.m_7654_().m_214005_();
                try {
                    profile = server.m_129925_().fillProfileProperties(unnamedProfile, enforceProfileSecurity);
                }
                catch (IllegalArgumentException e) {
                    SkyblockBuilder.getLogger().error("Problems filling profile properties for id {} with requiring secure {}", (Object)id, (Object)enforceProfileSecurity);
                    profile = unnamedProfile;
                }
                if (profile.getName() != null) {
                    profileCache.m_10991_(profile);
                    profiles.add(profile);
                    continue;
                }
                SkyblockBuilder.getLogger().info("No profile found for id {}", (Object)id);
                profiles.add(new GameProfile(profile.getId(), "Unknown"));
            }
        }
        SkyblockBuilder.getLogger().info("Cached profiles: {} ({} unused), uncached profiles: {}, total profiles: {}", new Object[]{cachedProfilesAmount, cachedProfilesAmount - usedCachedProfilesAmount, uncachedProfilesAmount, totalProfilesAmount});
        return profiles;
    }

    public static Set<TemplatesConfig.Spawn> fillTemplateFromWorld(StructureTemplate template, Level level, BlockPos pos, Vec3i box, boolean withEntities, Collection<Block> toIgnore) {
        HashSet<TemplatesConfig.Spawn> spawns = new HashSet<TemplatesConfig.Spawn>();
        if (box.m_123341_() >= 1 && box.m_123342_() >= 1 && box.m_123343_() >= 1) {
            BlockPos blockpos = pos.m_121955_(box).m_7918_(-1, -1, -1);
            ArrayList specialBlocks = Lists.newArrayList();
            ArrayList blocksWithTag = Lists.newArrayList();
            ArrayList normalBlocks = Lists.newArrayList();
            BlockPos minPos = new BlockPos(Math.min(pos.m_123341_(), blockpos.m_123341_()), Math.min(pos.m_123342_(), blockpos.m_123342_()), Math.min(pos.m_123343_(), blockpos.m_123343_()));
            BlockPos maxPos = new BlockPos(Math.max(pos.m_123341_(), blockpos.m_123341_()), Math.max(pos.m_123342_(), blockpos.m_123342_()), Math.max(pos.m_123343_(), blockpos.m_123343_()));
            template.f_74484_ = box;
            for (BlockPos actPos : BlockPos.m_121940_((BlockPos)minPos, (BlockPos)maxPos)) {
                BlockEntity blockEntity;
                BlockPos relPos = actPos.m_121996_((Vec3i)minPos);
                BlockState state = level.m_8055_(actPos);
                if (!toIgnore.isEmpty() && toIgnore.contains(state.m_60734_())) continue;
                if (state.m_60713_(ModBlocks.spawnBlock)) {
                    WorldUtil.Directions direction = WorldUtil.Directions.fromDirection((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_));
                    spawns.add(new TemplatesConfig.Spawn(relPos, direction));
                    if (toIgnore.contains(Blocks.f_50016_)) continue;
                    state = Blocks.f_50016_.m_49966_();
                }
                StructureTemplate.StructureBlockInfo blockInfo = (blockEntity = level.m_7702_(actPos)) != null ? new StructureTemplate.StructureBlockInfo(relPos, state, blockEntity.m_187481_()) : new StructureTemplate.StructureBlockInfo(relPos, state, null);
                StructureTemplate.m_74573_((StructureTemplate.StructureBlockInfo)blockInfo, (List)specialBlocks, (List)blocksWithTag, (List)normalBlocks);
            }
            List sortedBlocks = StructureTemplate.m_74614_((List)specialBlocks, (List)blocksWithTag, (List)normalBlocks);
            template.f_74482_.clear();
            template.f_74482_.add(new StructureTemplate.Palette(sortedBlocks));
            if (withEntities) {
                template.m_74500_(level, minPos, maxPos.m_7918_(1, 1, 1));
            } else {
                template.f_74483_.clear();
            }
        }
        return spawns;
    }

    public static String normalize(String s) {
        return s.toLowerCase(Locale.ROOT).replaceAll("\\W+", "_");
    }

    @Deprecated(forRemoval=true)
    @RemoveIn(minecraft="1.21")
    public static Path getFilePath(Path parentFolder, String name) {
        return RandomUtility.getFilePath(parentFolder, name, "nbt");
    }

    public static Path getFilePath(Path parentFolder, String name, String extension) {
        String filename;
        Path filepath;
        int index = 0;
        do {
            filename = (name == null ? "template" : RandomUtility.normalize(name)) + (String)(index == 0 ? "" : "_" + index) + "." + extension;
            ++index;
        } while (Files.exists(filepath = parentFolder.resolve(filename), new LinkOption[0]));
        return filepath;
    }

    public static String shorten(@Nonnull Font font, String name, int length) {
        Object s = name;
        int k = 0;
        while (font.m_92895_((String)s) > length) {
            s = name.substring(0, name.length() - k).trim() + "...";
            ++k;
        }
        return s;
    }
}

