/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.config.mapper;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.config.mapper.BlockPosMapper;
import de.melanx.skyblockbuilder.template.TemplateInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import org.moddingx.libx.config.gui.ConfigEditor;
import org.moddingx.libx.config.mapper.ValueMapper;
import org.moddingx.libx.config.validator.ValidatorInfo;
import org.moddingx.libx.impl.config.ModMappers;
import org.moddingx.libx.impl.config.mappers.special.RecordValueMapper;

public class SpreadInfoMapper
implements ValueMapper<TemplateInfo.SpreadInfo, JsonObject> {
    public Class<TemplateInfo.SpreadInfo> type() {
        return TemplateInfo.SpreadInfo.class;
    }

    public Class<JsonObject> element() {
        return JsonObject.class;
    }

    public TemplateInfo.SpreadInfo fromJson(JsonObject json) {
        BlockPos maxOffset;
        BlockPos minOffset;
        if (json.has("minOffset") && json.has("maxOffset")) {
            minOffset = BlockPosMapper.fromJsonArray(json.getAsJsonArray("minOffset"));
            maxOffset = BlockPosMapper.fromJsonArray(json.getAsJsonArray("maxOffset"));
        } else if (json.has("offset")) {
            maxOffset = minOffset = BlockPosMapper.fromJsonArray(json.getAsJsonArray("offset"));
        } else {
            throw new IllegalArgumentException("No offset provided: " + json);
        }
        TemplateInfo.SpreadInfo.Origin origin = TemplateInfo.SpreadInfo.Origin.ZERO;
        if (json.has("origin")) {
            origin = TemplateInfo.SpreadInfo.Origin.valueOf(json.get("origin").getAsString().toUpperCase(Locale.ROOT));
        }
        return new TemplateInfo.SpreadInfo(json.get("file").getAsString(), minOffset, maxOffset, origin);
    }

    public JsonObject toJson(TemplateInfo.SpreadInfo value) {
        JsonObject json = new JsonObject();
        json.addProperty("file", value.file());
        if (value.minOffset().m_121878_() == value.maxOffset().m_121878_()) {
            json.add("offset", (JsonElement)BlockPosMapper.toJsonArray(value.minOffset()));
        } else {
            json.add("minOffset", (JsonElement)BlockPosMapper.toJsonArray(value.minOffset()));
            json.add("maxOffset", (JsonElement)BlockPosMapper.toJsonArray(value.maxOffset()));
        }
        if (value.origin() != TemplateInfo.SpreadInfo.Origin.ZERO) {
            json.addProperty("origin", value.origin().name());
        }
        return json;
    }

    public ConfigEditor<TemplateInfo.SpreadInfo> createEditor(ValidatorInfo<?> validator) {
        try {
            Method method = ModMappers.class.getDeclaredMethod("getMapper", Type.class);
            method.setAccessible(true);
            ModMappers modMappers = ModMappers.get((String)SkyblockBuilder.getInstance().modid);
            return new RecordValueMapper(SkyblockBuilder.getInstance().modid, TemplateInfo.SpreadInfo.class, type -> {
                try {
                    return (ValueMapper)method.invoke((Object)modMappers, type);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }).createEditor(validator);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

