/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.compat.heracles;

import de.melanx.skyblockbuilder.client.GameProfileCache;
import de.melanx.skyblockbuilder.compat.heracles.HeraclesEventHandler;
import de.melanx.skyblockbuilder.compat.heracles.SpreadLocationTask;
import de.melanx.skyblockbuilder.compat.heracles.SpreadTaskSettings;
import de.melanx.skyblockbuilder.compat.heracles.SpreadTaskWidget;
import de.melanx.skyblockbuilder.config.common.HeraclesConfig;
import earth.terrarium.heracles.api.client.settings.SettingInitializer;
import earth.terrarium.heracles.api.client.settings.Settings;
import earth.terrarium.heracles.api.tasks.QuestTask;
import earth.terrarium.heracles.api.tasks.QuestTaskDisplayFormatter;
import earth.terrarium.heracles.api.tasks.client.QuestTaskWidgets;
import earth.terrarium.heracles.api.tasks.client.display.TaskTitleFormatter;
import earth.terrarium.heracles.api.tasks.client.display.TaskTitleFormatters;
import earth.terrarium.heracles.common.handlers.progress.QuestProgressHandler;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.NumericTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.MinecraftForge;

public class HeraclesCompat {
    public static final String MODID = "heracles";

    public static void registerHeracles() {
        SpreadLocationTask.register();
        QuestTaskDisplayFormatter.register(SpreadLocationTask.TYPE, (progress, task) -> String.format("%d/%d", task.storage().read((NumericTag)progress.progress()) != false ? 1 : 0, 1));
        TaskTitleFormatter.register(SpreadLocationTask.TYPE, task -> {
            if (task.predicate().getSpreads().size() > 1) {
                return Component.m_237110_((String)TaskTitleFormatters.toTranslationKey((QuestTask)task, (boolean)false), (Object[])new Object[]{task.predicate().getSpreads().size()});
            }
            return Component.m_237115_((String)TaskTitleFormatters.toTranslationKey((QuestTask)task, (boolean)true));
        });
        MinecraftForge.EVENT_BUS.register((Object)new HeraclesEventHandler());
    }

    public static void resetQuestProgress(Collection<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            HeraclesCompat.resetQuestProgress(player);
        }
    }

    public static void resetQuestProgress(ServerPlayer player) {
        if (!HeraclesConfig.resetQuestProgress || player.m_20310_(2)) {
            return;
        }
        QuestProgressHandler.getProgress((MinecraftServer)player.f_8924_, (UUID)player.m_20148_()).reset();
        player.m_240418_((Component)Component.m_237115_((String)"heracles.skyblockbuilder.reset_quest_progress").m_130940_(ChatFormatting.RED), true);
    }

    public static void resetQuestProgress(MinecraftServer server, UUID player) {
        if (!HeraclesConfig.resetQuestProgress || server.m_129944_(GameProfileCache.get(player)) >= 2) {
            return;
        }
        QuestProgressHandler.getProgress((MinecraftServer)server, (UUID)player).reset();
    }

    public static void registerHeraclesClient() {
        Settings.register(SpreadLocationTask.TYPE, (SettingInitializer)SpreadTaskSettings.INSTANCE);
        QuestTaskWidgets.registerSimple(SpreadLocationTask.TYPE, SpreadTaskWidget::new);
    }
}

