/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.config.common.InventoryConfig;
import de.melanx.skyblockbuilder.config.common.PermissionsConfig;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.WorldUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class LeaveCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.m_82127_((String)"leave").executes(context -> LeaveCommand.leaveTeam((CommandSourceStack)context.getSource()));
    }

    private static int leaveTeam(CommandSourceStack source) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.m_81372_();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        ServerPlayer player = source.m_81375_();
        if (!data.hasPlayerTeam((Player)player)) {
            source.m_288197_(() -> Component.m_237115_((String)"skyblockbuilder.command.error.user_has_no_team").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        Team team = data.getTeamFromPlayer((Player)player);
        switch (SkyblockHooks.onLeave(player, team)) {
            case DENY: {
                source.m_288197_(() -> Component.m_237115_((String)"skyblockbuilder.command.denied.leave_team").m_130940_(ChatFormatting.RED), false);
                return 0;
            }
            case DEFAULT: {
                if (PermissionsConfig.selfManage || source.m_6761_(2)) break;
                source.m_288197_(() -> Component.m_237115_((String)"skyblockbuilder.command.disabled.manage_teams").m_130940_(ChatFormatting.RED), false);
                return 0;
            }
        }
        if (InventoryConfig.dropItems) {
            RandomUtility.dropInventories((Player)player);
        }
        data.removePlayerFromTeam((Player)player);
        source.m_288197_(() -> Component.m_237115_((String)"skyblockbuilder.command.success.left_team").m_130940_(ChatFormatting.GOLD), true);
        RandomUtility.deleteTeamIfEmpty(data, team);
        WorldUtil.teleportToIsland(player, data.getSpawn());
        return 1;
    }
}

