/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.config.common.PermissionsConfig;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.WorldUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class HomeCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.m_82127_((String)"home").executes(context -> HomeCommand.home((CommandSourceStack)context.getSource()));
    }

    private static int home(CommandSourceStack source) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.m_81372_();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        ServerPlayer player = source.m_81375_();
        Team team = data.getTeamFromPlayer((Player)player);
        if (team == null) {
            source.m_288197_(() -> Component.m_237115_((String)"skyblockbuilder.command.error.user_has_no_team").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        if (!player.m_20310_(2) && !data.getOrCreateMetaInfo((Player)player).canTeleportHome(level.m_46467_())) {
            source.m_81352_((Component)Component.m_237110_((String)"skyblockbuilder.command.error.cooldown", (Object[])new Object[]{RandomUtility.formattedCooldown((long)PermissionsConfig.Teleports.homeCooldown - (level.m_46467_() - data.getOrCreateMetaInfo((Player)player).getLastHomeTeleport()))}));
            return 0;
        }
        if (!player.m_20310_(2) && !PermissionsConfig.Teleports.teleportationDimensions.test(player.m_9236_().m_46472_().m_135782_())) {
            source.m_81352_((Component)Component.m_237115_((String)"skyblockbuilder.command.error.teleportation_not_allowed_dimension"));
            return 0;
        }
        if (!player.m_20310_(2) && !PermissionsConfig.Teleports.crossDimensionTeleportation && player.m_9236_() != data.getLevel()) {
            source.m_81352_((Component)Component.m_237115_((String)"skyblockbuilder.command.error.teleport_across_dimensions"));
            return 0;
        }
        if (!player.m_20310_(2) && PermissionsConfig.Teleports.preventWhileFalling && player.f_19789_ > 1.0f) {
            source.m_81352_((Component)Component.m_237115_((String)"skyblockbuilder.command.error.prevent_while_falling"));
            return 0;
        }
        switch (SkyblockHooks.onHome(player, team)) {
            case DENY: {
                source.m_288197_(() -> Component.m_237115_((String)"skyblockbuilder.command.denied.teleport_home").m_130940_(ChatFormatting.RED), false);
                return 0;
            }
            case DEFAULT: {
                if (PermissionsConfig.Teleports.home || source.m_6761_(2)) break;
                source.m_288197_(() -> Component.m_237115_((String)"skyblockbuilder.command.disabled.teleport_home").m_130940_(ChatFormatting.RED), false);
                return 0;
            }
        }
        data.getOrCreateMetaInfo((Player)player).setLastHomeTeleport(level.m_46467_());
        source.m_288197_(() -> Component.m_237115_((String)"skyblockbuilder.command.success.teleport_home").m_130940_(ChatFormatting.GOLD), true);
        WorldUtil.teleportToIsland(player, team);
        return 1;
    }
}

