/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.util;

import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.util.ComponentBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ToggleButtons {
    private static final Component ALLOWED = ComponentBuilder.text("allowed", new Object[0]).withStyle(ChatFormatting.GREEN);
    private static final Component DISALLOWED = ComponentBuilder.text("disallowed", new Object[0]).withStyle(ChatFormatting.RED);

    public static void toggleState(Team team, AbstractWidget widget, MutableComponent base, Type type) {
        switch (type.ordinal()) {
            case 0: {
                team.setAllowVisit(!team.allowsVisits());
                break;
            }
            case 1: {
                team.setAllowJoinRequest(!team.allowsJoinRequests());
            }
        }
        widget.setTooltip(Tooltip.create((Component)base.copy().append(ToggleButtons.getStatus(team, type) ? ALLOWED : DISALLOWED)));
        SkyGUIs.getNetwork().toggleState(team, type);
    }

    public static boolean getStatus(Team team, Type type) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> team.allowsVisits();
            case 1 -> team.allowsJoinRequests();
        };
    }

    public static enum Type {
        VISITS,
        JOIN_REQUEST;

    }
}

