/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.network.handler;

import com.google.common.collect.Sets;
import de.melanx.skyblockbuilder.config.common.InventoryConfig;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.SkyComponents;
import de.melanx.skyblockbuilder.util.WorldUtil;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.network.EasyNetwork;
import de.melanx.skyguis.util.ComponentBuilder;
import de.melanx.skyguis.util.LoadingResult;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.HandlerThread;
import org.apache.commons.lang3.tuple.Pair;
import org.moddingx.libx.network.PacketHandler;

public class UpdateTeam
extends PacketHandler<Message> {
    public static final CustomPacketPayload.Type<Message> TYPE = new CustomPacketPayload.Type(SkyGUIs.getInstance().resource("update_team"));

    public UpdateTeam() {
        super(TYPE, PacketFlow.SERVERBOUND, Message.CODEC, HandlerThread.MAIN);
    }

    public void handle(Message msg, IPayloadContext ctx) {
        ServerPlayer player = (ServerPlayer)ctx.player();
        EasyNetwork network = SkyGUIs.getNetwork();
        if (!player.hasPermissions(2)) {
            network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)ComponentBuilder.text("missing_permissions", new Object[0]));
            return;
        }
        ServerLevel level = (ServerLevel)player.level();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        Team team = data.getTeamFromPlayer((Player)player);
        if (team == null) {
            network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.ERROR_USER_HAS_NO_TEAM);
            return;
        }
        PlayerList playerList = level.getServer().getPlayerList();
        Pair result = SkyblockHooks.onManageRemoveFromTeam(null, (Team)team, (Collection)msg.players.stream().map(arg_0 -> ((PlayerList)playerList).getPlayer(arg_0)).collect(Collectors.toList()));
        if (((Boolean)result.getLeft()).booleanValue()) {
            network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.DENIED_REMOVE_PLAYERS_FROM_TEAM);
            return;
        }
        if (team.getName().equalsIgnoreCase(msg.teamName)) {
            for (UUID id : msg.players) {
                if (!team.hasPlayer(id)) continue;
                data.removePlayerFromTeam(id);
                ServerPlayer toRemove = playerList.getPlayer(id);
                if (toRemove == null) continue;
                if (InventoryConfig.dropItems) {
                    RandomUtility.dropInventories((Player)toRemove);
                }
                WorldUtil.teleportToIsland((ServerPlayer)toRemove, (Team)data.getSpawn());
            }
        } else {
            network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)ComponentBuilder.text("player_not_in_team", new Object[0]));
            return;
        }
        network.handleLoadingResult(ctx, LoadingResult.Status.SUCCESS, (Component)SkyComponents.SUCCESS_REMOVE_MULTIPLE_PLAYERS.apply(msg.players.size(), team.getName()));
    }

    public record Message(String teamName, Set<UUID> players) implements CustomPacketPayload
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, Message> CODEC = StreamCodec.of((buffer, msg) -> {
            buffer.writeUtf(msg.teamName);
            buffer.writeVarInt(msg.players.size());
            for (UUID id : msg.players) {
                buffer.writeUUID(id);
            }
        }, buffer -> {
            String teamName = buffer.readUtf();
            int size = buffer.readVarInt();
            HashSet ids = Sets.newHashSet();
            for (int i = 0; i < size; ++i) {
                ids.add(buffer.readUUID());
            }
            return new Message(teamName, ids);
        });

        @Nonnull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

