/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.network.handler;

import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.permissions.PermissionManager;
import de.melanx.skyblockbuilder.util.SkyComponents;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.network.EasyNetwork;
import de.melanx.skyguis.util.LoadingResult;
import javax.annotation.Nonnull;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.HandlerThread;
import org.moddingx.libx.network.PacketHandler;

public class AnswerInvitation
extends PacketHandler<Message> {
    public static final CustomPacketPayload.Type<Message> TYPE = new CustomPacketPayload.Type(SkyGUIs.getInstance().resource("answer_invitation"));

    public AnswerInvitation() {
        super(TYPE, PacketFlow.SERVERBOUND, Message.CODEC, HandlerThread.MAIN);
    }

    public void handle(Message msg, IPayloadContext ctx) {
        ServerPlayer player = (ServerPlayer)ctx.player();
        SkyblockSavedData data = SkyblockSavedData.get((Level)player.getCommandSenderWorld());
        Team team = data.getTeam(msg.teamName);
        EasyNetwork network = SkyGUIs.getNetwork();
        switch (msg.answerType.ordinal()) {
            case 0: {
                if (team == null) {
                    network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.ERROR_TEAM_NOT_EXIST);
                    return;
                }
                if (data.hasPlayerTeam((Player)player)) {
                    network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.ERROR_USER_HAS_TEAM);
                    return;
                }
                if (!data.hasInvites((Player)player)) {
                    network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.ERROR_NO_INVITATIONS);
                    return;
                }
                switch (SkyblockHooks.onAccept((ServerPlayer)player, (Team)team)) {
                    case DENY: {
                        network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.DENIED_ACCEPT_INVITATIONS);
                        return;
                    }
                    case DEFAULT: {
                        if (PermissionManager.INSTANCE.hasPermission((Player)player, PermissionManager.Permission.TEAM_HANDLE_INVITES)) break;
                        network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.DISABLED_ACCEPT_INVITATIONS);
                        return;
                    }
                }
                if (!data.acceptInvite(team, (Player)player)) {
                    network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.ERROR_ACCEPT_INVITATIONS);
                    return;
                }
                network.handleLoadingResult(ctx, LoadingResult.Status.SUCCESS, (Component)SkyComponents.SUCCESS_JOINED_TEAM.apply(team.getName()));
                break;
            }
            case 1: {
                if (team == null) {
                    network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.ERROR_TEAM_NOT_EXIST);
                    return;
                }
                if (!data.hasInvites((Player)player)) {
                    network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.ERROR_NO_INVITATIONS);
                    return;
                }
                switch (SkyblockHooks.onDecline((ServerPlayer)player, (Team)team)) {
                    case DENY: {
                        network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.DENIED_DECLINE_INVITATIONS);
                        return;
                    }
                    case DEFAULT: {
                        if (PermissionManager.INSTANCE.hasPermission((Player)player, PermissionManager.Permission.TEAM_HANDLE_INVITES)) break;
                        network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.DISABLED_DECLINE_INVITATIONS);
                        return;
                    }
                }
                if (!data.declineInvite(team, (Player)player)) {
                    network.handleLoadingResult(ctx, LoadingResult.Status.FAIL, (Component)SkyComponents.ERROR_DECLINE_INVITATIONS);
                    return;
                }
                network.handleLoadingResult(ctx, LoadingResult.Status.SUCCESS, (Component)SkyComponents.SUCCESS_DECLINED_INVITATION.apply(team.getName()));
            }
        }
    }

    public record Message(String teamName, Type answerType) implements CustomPacketPayload
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, Message> CODEC = StreamCodec.of((buffer, msg) -> {
            buffer.writeUtf(msg.teamName);
            buffer.writeEnum((Enum)msg.answerType);
        }, buffer -> new Message(buffer.readUtf(), (Type)buffer.readEnum(Type.class)));

        @Nonnull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }

    public static enum Type {
        ACCEPT,
        IGNORE;

    }
}

