/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.client.screen.base.list;

import com.google.common.collect.Lists;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyguis.client.screen.base.list.ListScreen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class TeamListScreen
extends ListScreen<Team> {
    public TeamListScreen(Component title, List<Team> teams, int xSize, int ySize, ListScreen.ScrollbarInfo scrollbarInfo, ListScreen.RenderAreaInfo renderAreaInfo) {
        super(title, teams, xSize, ySize, scrollbarInfo, renderAreaInfo);
    }

    @Override
    protected int entriesPerPage() {
        return 10;
    }

    @Override
    protected void fillWidgets() {
        for (int i = 0; i < this.values.size(); ++i) {
            this.addCheckboxWidget(this.renderArea.addRenderableWidget2(new TeamWidget(this, (Team)this.values.get(i), this, 0, 14 * i, 100, 12)));
        }
    }

    protected class TeamWidget
    extends ListScreen.CheckboxTextWidget {
        public TeamWidget(TeamListScreen this$0, Team team, Screen screen, int x, int y, int width, int height) {
            super(this$0, team, screen, x, y, width, height, TeamWidget.buildTooltip(team), (Component)Component.literal((String)team.getName()));
        }

        private static List<Component> buildTooltip(Team team) {
            ArrayList tooltip = Lists.newArrayList((Object[])new Component[]{Component.literal((String)team.getName())});
            if (Minecraft.getInstance().options.advancedItemTooltips) {
                tooltip.add(Component.literal((String)team.getId().toString()).withStyle(ChatFormatting.GRAY));
            }
            return tooltip;
        }
    }
}

