/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.network.handler;

import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.client.screen.notification.InformationScreen;
import de.melanx.skyguis.util.LoadingResult;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.HandlerThread;
import org.moddingx.libx.network.PacketHandler;

public class SendLoadingResult
extends PacketHandler<Message> {
    public static final CustomPacketPayload.Type<Message> TYPE = new CustomPacketPayload.Type(SkyGUIs.getInstance().resource("send_loading_result"));

    public SendLoadingResult() {
        super(TYPE, PacketFlow.CLIENTBOUND, Message.CODEC, HandlerThread.MAIN);
    }

    public void handle(Message msg, IPayloadContext ctx) {
        switch (msg.status) {
            case SUCCESS: {
                Minecraft.getInstance().popGuiLayer();
                ctx.player().sendSystemMessage((Component)msg.reason.copy().withStyle(ChatFormatting.GOLD));
                break;
            }
            case FAIL: {
                InformationScreen.open(msg.reason);
            }
        }
    }

    public record Message(LoadingResult.Status status, Component reason) implements CustomPacketPayload
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, Message> CODEC = StreamCodec.of((buffer, msg) -> {
            buffer.writeEnum((Enum)msg.status);
            ComponentSerialization.TRUSTED_STREAM_CODEC.encode(buffer, (Object)msg.reason);
        }, buffer -> new Message((LoadingResult.Status)buffer.readEnum(LoadingResult.Status.class), (Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode(buffer)));

        @Nonnull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

