/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.network.handler;

import de.melanx.skyblockbuilder.config.ConfigHandler;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.util.WorldUtil;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.network.EasyNetwork;
import de.melanx.skyguis.util.LoadingResult;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import org.moddingx.libx.network.PacketHandler;
import org.moddingx.libx.network.PacketSerializer;

public record VisitTeam(UUID team) {

    public static class Serializer
    implements PacketSerializer<VisitTeam> {
        public Class<VisitTeam> messageClass() {
            return VisitTeam.class;
        }

        public void encode(VisitTeam msg, FriendlyByteBuf buffer) {
            buffer.m_130077_(msg.team);
        }

        public VisitTeam decode(FriendlyByteBuf buffer) {
            return new VisitTeam(buffer.m_130259_());
        }
    }

    public static class Handler
    implements PacketHandler<VisitTeam> {
        public PacketHandler.Target target() {
            return PacketHandler.Target.MAIN_THREAD;
        }

        public boolean handle(VisitTeam msg, Supplier<NetworkEvent.Context> ctx) {
            ServerPlayer player = ctx.get().getSender();
            if (player == null) {
                return true;
            }
            EasyNetwork network = SkyGUIs.getNetwork();
            if (!ConfigHandler.Utility.Teleports.allowVisits && !player.m_20310_(1)) {
                network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.disabled.team_visit"));
                return true;
            }
            ServerLevel level = player.m_9236_();
            SkyblockSavedData data = SkyblockSavedData.get((Level)level);
            Team team = data.getTeam(msg.team);
            if (team == null) {
                return true;
            }
            if (!team.allowsVisits() && !player.m_20310_(1)) {
                network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.disabled.visit_team"));
                return true;
            }
            if (team.equals((Object)data.getTeamFromPlayer((Player)player))) {
                network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.error.visit_own_team"));
                return true;
            }
            WorldUtil.teleportToIsland((ServerPlayer)player, (Team)team);
            network.handleLoadingResult(ctx.get(), LoadingResult.Status.SUCCESS, (Component)Component.m_237110_((String)"skyblockbuilder.command.success.visit_team", (Object[])new Object[]{team.getName()}));
            return true;
        }
    }
}

