/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.network.handler;

import de.melanx.skyblockbuilder.config.ConfigHandler;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.data.TemplateData;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.network.EasyNetwork;
import de.melanx.skyguis.util.LoadingResult;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkEvent;
import org.moddingx.libx.network.PacketHandler;
import org.moddingx.libx.network.PacketSerializer;

public record EditSpawns(Type type, BlockPos pos) {

    public static enum Type {
        ADD,
        REMOVE,
        RESET;

    }

    public static class Serializer
    implements PacketSerializer<EditSpawns> {
        public Class<EditSpawns> messageClass() {
            return EditSpawns.class;
        }

        public void encode(EditSpawns msg, FriendlyByteBuf buffer) {
            buffer.m_130068_((Enum)msg.type);
            buffer.m_130064_(msg.pos);
        }

        public EditSpawns decode(FriendlyByteBuf buffer) {
            return new EditSpawns((Type)buffer.m_130066_(Type.class), buffer.m_130135_());
        }
    }

    public static class Handler
    implements PacketHandler<EditSpawns> {
        public PacketHandler.Target target() {
            return PacketHandler.Target.MAIN_THREAD;
        }

        public boolean handle(EditSpawns msg, Supplier<NetworkEvent.Context> ctx) {
            ServerPlayer player = ctx.get().getSender();
            if (player == null) {
                return true;
            }
            EasyNetwork network = SkyGUIs.getNetwork();
            ServerLevel level = (ServerLevel)player.m_20193_();
            SkyblockSavedData data = SkyblockSavedData.get((Level)level);
            Team team = data.getTeamFromPlayer((Player)player);
            if (team == null) {
                network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.error.user_has_no_team").m_130940_(ChatFormatting.RED));
                return true;
            }
            switch (msg.type) {
                case ADD: {
                    Event.Result result = (Event.Result)SkyblockHooks.onAddSpawn((ServerPlayer)player, (Team)team, (BlockPos)msg.pos).getLeft();
                    switch (result) {
                        case DENY: {
                            network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.denied.create_spawn"));
                            return true;
                        }
                        case DEFAULT: {
                            if (!(ConfigHandler.Utility.selfManage && ConfigHandler.Utility.Spawns.modifySpawns || player.m_20310_(2))) {
                                network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.disabled.modify_spawns"));
                                return true;
                            }
                            Vec3i templateSize = TemplateData.get((ServerLevel)level).getConfiguredTemplate().getTemplate().m_163801_();
                            BlockPos.MutableBlockPos center = team.getIsland().getCenter().m_122032_();
                            center.m_7918_(templateSize.m_123341_() / 2, templateSize.m_123342_() / 2, templateSize.m_123343_() / 2);
                            if (msg.pos.m_123314_((Vec3i)center, (double)ConfigHandler.Utility.Spawns.range)) break;
                            network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.error.position_too_far_away"));
                            return true;
                        }
                    }
                    team.addPossibleSpawn(msg.pos);
                    network.handleLoadingResult(ctx.get(), LoadingResult.Status.SUCCESS, (Component)Component.m_237110_((String)"skyblockbuilder.command.success.spawn_added", (Object[])new Object[]{msg.pos.m_123341_(), msg.pos.m_123342_(), msg.pos.m_123343_()}));
                    return true;
                }
                case REMOVE: {
                    if (level != level.m_7654_().m_129880_(ConfigHandler.Spawn.dimension)) {
                        network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.error.wrong_position"));
                        return true;
                    }
                    Event.Result result = SkyblockHooks.onRemoveSpawn((ServerPlayer)player, (Team)team, (BlockPos)msg.pos);
                    switch (result) {
                        case DENY: {
                            network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.denied.modify_spawns0"));
                            return true;
                        }
                        case DEFAULT: {
                            if (ConfigHandler.Utility.selfManage && ConfigHandler.Utility.Spawns.modifySpawns || player.m_20310_(2)) break;
                            network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.disabled.modify_spawns"));
                            return true;
                        }
                    }
                    if (!team.removePossibleSpawn(msg.pos)) {
                        MutableComponent answer = Component.m_237115_((String)"skyblockbuilder.command.error.remove_spawn0");
                        if (team.getPossibleSpawns().size() <= 1) {
                            answer.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"skyblockbuilder.command.error.remove_spawn1"));
                        }
                        network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)answer);
                        return true;
                    }
                    network.handleLoadingResult(ctx.get(), LoadingResult.Status.SUCCESS, (Component)Component.m_237110_((String)"skyblockbuilder.command.success.spawn_removed", (Object[])new Object[]{msg.pos.m_123341_(), msg.pos.m_123342_(), msg.pos.m_123343_()}));
                    return true;
                }
            }
            return true;
        }
    }
}

