/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.network.handler;

import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.template.ConfiguredTemplate;
import de.melanx.skyblockbuilder.template.TemplateLoader;
import de.melanx.skyblockbuilder.util.WorldUtil;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.network.EasyNetwork;
import de.melanx.skyguis.util.ComponentBuilder;
import de.melanx.skyguis.util.LoadingResult;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import org.moddingx.libx.network.PacketHandler;
import org.moddingx.libx.network.PacketSerializer;

public record CreateTeamScreenClick(String name, String shape) {

    public static class Serializer
    implements PacketSerializer<CreateTeamScreenClick> {
        public Class<CreateTeamScreenClick> messageClass() {
            return CreateTeamScreenClick.class;
        }

        public void encode(CreateTeamScreenClick msg, FriendlyByteBuf buffer) {
            buffer.m_130070_(msg.name);
            buffer.m_130070_(msg.shape);
        }

        public CreateTeamScreenClick decode(FriendlyByteBuf buffer) {
            return new CreateTeamScreenClick(buffer.m_130277_(), buffer.m_130277_());
        }
    }

    public static class Handler
    implements PacketHandler<CreateTeamScreenClick> {
        public PacketHandler.Target target() {
            return PacketHandler.Target.MAIN_THREAD;
        }

        public boolean handle(CreateTeamScreenClick msg, Supplier<NetworkEvent.Context> ctx) {
            ServerPlayer player = ctx.get().getSender();
            if (player == null) {
                return true;
            }
            EasyNetwork network = SkyGUIs.getNetwork();
            if (SkyblockHooks.onCreateTeam((String)msg.name)) {
                network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.denied.create_team").m_130940_(ChatFormatting.RED));
                return true;
            }
            ServerLevel level = player.m_9236_();
            ConfiguredTemplate template = TemplateLoader.getConfiguredTemplate((String)msg.shape);
            if (template == null) {
                network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)ComponentBuilder.text("shape_does_not_exist", new Object[0]).m_130940_(ChatFormatting.RED));
                return true;
            }
            SkyblockSavedData data = SkyblockSavedData.get((Level)level);
            if (data.hasPlayerTeam((Player)player)) {
                network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.error.user_has_team").m_130940_(ChatFormatting.RED));
                return true;
            }
            Team team = data.createTeam(msg.name, template);
            if (team == null) {
                network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237110_((String)"skyblockbuilder.command.error.team_already_exist", (Object[])new Object[]{msg.name}).m_130940_(ChatFormatting.RED));
                return true;
            }
            team.addPlayer((Player)player);
            WorldUtil.teleportToIsland((ServerPlayer)player, (Team)team);
            network.handleLoadingResult(ctx.get(), LoadingResult.Status.SUCCESS, (Component)Component.m_237110_((String)"skyblockbuilder.command.success.create_team", (Object[])new Object[]{team.getName()}).m_130940_(ChatFormatting.GREEN));
            return true;
        }
    }
}

