/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.network.handler;

import de.melanx.skyblockbuilder.config.ConfigHandler;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.network.EasyNetwork;
import de.melanx.skyguis.util.LoadingResult;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import org.moddingx.libx.network.PacketHandler;
import org.moddingx.libx.network.PacketSerializer;

public record AnswerInvitation(String teamName, Type type) {

    public static enum Type {
        ACCEPT,
        IGNORE;

    }

    public static class Serializer
    implements PacketSerializer<AnswerInvitation> {
        public Class<AnswerInvitation> messageClass() {
            return AnswerInvitation.class;
        }

        public void encode(AnswerInvitation msg, FriendlyByteBuf buffer) {
            buffer.m_130070_(msg.teamName);
            buffer.m_130068_((Enum)msg.type);
        }

        public AnswerInvitation decode(FriendlyByteBuf buffer) {
            return new AnswerInvitation(buffer.m_130277_(), (Type)buffer.m_130066_(Type.class));
        }
    }

    public static class Handler
    implements PacketHandler<AnswerInvitation> {
        public PacketHandler.Target target() {
            return PacketHandler.Target.MAIN_THREAD;
        }

        public boolean handle(AnswerInvitation msg, Supplier<NetworkEvent.Context> ctx) {
            ServerPlayer player = ctx.get().getSender();
            if (player == null) {
                return true;
            }
            SkyblockSavedData data = SkyblockSavedData.get((Level)player.m_20193_());
            Team team = data.getTeam(msg.teamName);
            EasyNetwork network = SkyGUIs.getNetwork();
            switch (msg.type) {
                case ACCEPT: {
                    if (team == null) {
                        network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.error.team_not_exist").m_130940_(ChatFormatting.RED));
                        return true;
                    }
                    if (data.hasPlayerTeam((Player)player)) {
                        network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.error.user_has_team").m_130940_(ChatFormatting.RED));
                        return true;
                    }
                    if (!data.hasInvites((Player)player)) {
                        network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.error.no_invitations").m_130940_(ChatFormatting.RED));
                        return true;
                    }
                    switch (SkyblockHooks.onAccept((ServerPlayer)player, (Team)team)) {
                        case DENY: {
                            network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.denied.accept_invitations").m_130940_(ChatFormatting.RED));
                            return true;
                        }
                        case DEFAULT: {
                            if (ConfigHandler.Utility.selfManage || player.m_20310_(2)) break;
                            network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.disabled.accept_invitations").m_130940_(ChatFormatting.RED));
                            return true;
                        }
                    }
                    if (!data.acceptInvite(team, (Player)player)) {
                        network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.error.accept_invitations").m_130940_(ChatFormatting.RED));
                        return true;
                    }
                    network.handleLoadingResult(ctx.get(), LoadingResult.Status.SUCCESS, (Component)Component.m_237115_((String)"skyblockbuilder.command.success.joined_team").m_130940_(ChatFormatting.GOLD));
                    break;
                }
                case IGNORE: {
                    if (team == null) {
                        network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.error.team_not_exist").m_130940_(ChatFormatting.RED));
                        return true;
                    }
                    if (!data.hasInvites((Player)player)) {
                        network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.error.no_invitations").m_130940_(ChatFormatting.RED));
                        return true;
                    }
                    switch (SkyblockHooks.onDecline((ServerPlayer)player, (Team)team)) {
                        case DENY: {
                            network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.denied.decline_invitations").m_130940_(ChatFormatting.RED));
                            return true;
                        }
                        case DEFAULT: {
                            if (ConfigHandler.Utility.selfManage || player.m_20310_(2)) break;
                            network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.disabled.decline_invitations").m_130940_(ChatFormatting.RED));
                            return true;
                        }
                    }
                    if (!data.declineInvite(team, (Player)player)) {
                        network.handleLoadingResult(ctx.get(), LoadingResult.Status.FAIL, (Component)Component.m_237115_((String)"skyblockbuilder.command.error.decline_invitations").m_130940_(ChatFormatting.RED));
                        return true;
                    }
                    network.handleLoadingResult(ctx.get(), LoadingResult.Status.SUCCESS, (Component)Component.m_237110_((String)"skyblockbuilder.command.success.declined_invitation", (Object[])new Object[]{team.getName()}).m_130940_(ChatFormatting.GOLD));
                }
            }
            return true;
        }
    }
}

