/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.client.screen.info;

import com.mojang.blaze3d.vertex.PoseStack;
import de.melanx.skyblockbuilder.config.ConfigHandler;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.client.screen.BaseScreen;
import de.melanx.skyguis.client.screen.base.LoadingResultHandler;
import de.melanx.skyguis.client.screen.edit.InvitablePlayersScreen;
import de.melanx.skyguis.client.screen.edit.TeamPlayersScreen;
import de.melanx.skyguis.client.screen.notification.InformationScreen;
import de.melanx.skyguis.client.widget.BlinkingEditBox;
import de.melanx.skyguis.network.handler.EditSpawns;
import de.melanx.skyguis.util.ComponentBuilder;
import de.melanx.skyguis.util.LoadingResult;
import de.melanx.skyguis.util.TextHelper;
import java.awt.Color;
import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.phys.Vec3;

public class TeamEditScreen
extends BaseScreen
implements LoadingResultHandler {
    private static final Component SPAWNS = ComponentBuilder.text("spawns", new Object[0]);
    private static final Component MEMBERS = ComponentBuilder.text("members", new Object[0]);
    private static final Component INVALID = ComponentBuilder.text("invalid", new Object[0]);
    private static final Component ADD = ComponentBuilder.text("add", new Object[0]);
    private static final Component REMOVE = ComponentBuilder.text("remove", new Object[0]);
    private static final Component SHOW = ComponentBuilder.text("show", new Object[0]);
    private static final Component INVITE = ComponentBuilder.text("invite", new Object[0]);
    private final Team team;
    private final BaseScreen prev;
    private final Random random;
    private BlinkingEditBox posBox;
    private Button addButton;
    private Button removeButton;
    private boolean posValid;

    public TeamEditScreen(Team team, BaseScreen prev) {
        super((Component)Component.m_237113_((String)team.getName()), 245, 185);
        this.team = team;
        this.prev = prev;
        this.random = new Random();
    }

    protected void m_7856_() {
        this.m_142416_((GuiEventListener)new Button(this.x(10), this.y(45), 70, 20, SHOW, button -> {
            for (BlockPos spawn : this.team.getPossibleSpawns()) {
                double posX = (double)spawn.m_123341_() + 0.5;
                double posY = (double)spawn.m_123342_() + 0.5;
                double posZ = (double)spawn.m_123343_() + 0.5;
                for (int i = 0; i < 10; ++i) {
                    double offsetX = this.random.nextGaussian() * 0.1;
                    double offsetY = this.random.nextGaussian() * 0.1;
                    double offsetZ = this.random.nextGaussian() * 0.1;
                    double speedX = this.random.nextGaussian() * 10.0;
                    double speedY = this.random.nextGaussian() * 10.0;
                    double speedZ = this.random.nextGaussian() * 10.0;
                    this.f_96541_.f_91073_.m_6493_((ParticleOptions)ParticleTypes.f_123748_, false, posX + offsetX, posY + offsetY, posZ + offsetZ, speedX, speedY, speedZ);
                }
            }
            this.m_7379_();
        }));
        this.addButton = (Button)this.m_142416_((GuiEventListener)new Button(this.x(85), this.y(45), 70, 20, ADD, button -> {
            BlockPos pos = this.getPos();
            if (this.posValid && pos != null) {
                SkyGUIs.getNetwork().handleEditSpawns(EditSpawns.Type.ADD, pos);
                this.getLoadingCircle().setActive(true);
            }
        }, (button, poseStack, mouseX, mouseY) -> this.posBox.blink()));
        Vec3 pos = Minecraft.m_91087_().f_91074_.m_20182_();
        String posStr = (int)pos.f_82479_ + " " + (int)pos.f_82480_ + " " + (int)pos.f_82481_;
        this.posBox = new BlinkingEditBox(this.f_96547_, this.x(10), this.y(70), 145, 18, (Component)Component.m_237113_((String)posStr));
        this.posBox.m_94144_(posStr);
        this.posBox.m_94199_(Short.MAX_VALUE);
        this.m_142416_((GuiEventListener)this.posBox);
        this.removeButton = (Button)this.m_142416_((GuiEventListener)new Button(this.x(160), this.y(45), 70, 20, REMOVE, button -> {
            BlockPos removePos = this.getPos();
            if (this.posValid && removePos != null) {
                SkyGUIs.getNetwork().handleEditSpawns(EditSpawns.Type.REMOVE, removePos);
                this.getLoadingCircle().setActive(true);
            }
        }));
        this.m_142416_((GuiEventListener)new Button(this.x(10), this.y(115), 70, 20, SHOW, button -> Minecraft.m_91087_().m_91152_((Screen)new TeamPlayersScreen(this.team, this))));
        this.m_142416_((GuiEventListener)new Button(this.x(85), this.y(115), 70, 20, INVITE, button -> Minecraft.m_91087_().m_91152_((Screen)new InvitablePlayersScreen(this.team, this))));
        this.m_142416_((GuiEventListener)new Button(this.x(10), this.y(155), 226, 20, (Component)PREV_SCREEN_COMPONENT, button -> Minecraft.m_91087_().m_91152_((Screen)this.prev)));
        if (!ConfigHandler.Utility.selfManage || !ConfigHandler.Utility.Spawns.modifySpawns) {
            this.addButton.f_93623_ = false;
            this.removeButton.f_93623_ = false;
        }
    }

    @Override
    public void onLoadingResult(LoadingResult result) {
        Minecraft minecraft = Minecraft.m_91087_();
        minecraft.pushGuiLayer((Screen)new InformationScreen(result.reason(), TextHelper.stringLength((FormattedText)result.reason()) + 30, 100, () -> ((Minecraft)minecraft).popGuiLayer()));
    }

    @Override
    public void m_86600_() {
        this.posBox.m_94120_();
        this.updatePositionValidation();
        super.m_86600_();
    }

    @Override
    public void render_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        super.render_(poseStack, mouseX, mouseY, partialTick);
        this.renderTitle(poseStack);
        this.f_96547_.m_92889_(poseStack, SPAWNS, (float)this.x(10), (float)this.y(30), Color.DARK_GRAY.getRGB());
        this.f_96547_.m_92889_(poseStack, MEMBERS, (float)this.x(10), (float)this.y(100), Color.DARK_GRAY.getRGB());
        if (!this.posValid) {
            poseStack.m_85836_();
            poseStack.m_85841_(1.3f, 1.3f, 1.3f);
            this.f_96547_.m_92889_(poseStack, INVALID, (float)((double)(this.x(191) - this.f_96547_.m_92852_((FormattedText)INVALID) / 2) / 1.3), (float)((double)this.y(74) / 1.3), Color.RED.getRGB());
            poseStack.m_85849_();
        }
    }

    private void updatePositionValidation() {
        String posBoxValue = this.posBox.m_94155_();
        String[] args = posBoxValue.split(" ");
        boolean bl = this.posValid = args.length == 3 && Arrays.stream(args).allMatch(s -> {
            try {
                Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }) && Integer.parseInt(args[1]) >= Minecraft.m_91087_().f_91073_.m_141937_() && Integer.parseInt(args[1]) <= Minecraft.m_91087_().f_91073_.m_151558_();
        if (this.posValid) {
            this.posBox.setValid();
            if (ConfigHandler.Utility.selfManage && ConfigHandler.Utility.Spawns.modifySpawns) {
                this.addButton.f_93623_ = true;
                this.removeButton.f_93623_ = true;
            }
        } else {
            this.posBox.setInvalid();
            this.addButton.f_93623_ = false;
            this.removeButton.f_93623_ = false;
        }
    }

    @Nullable
    private BlockPos getPos() {
        if (this.posValid) {
            String value = this.posBox.m_94155_();
            String[] args = value.split(" ");
            int x = Integer.parseInt(args[0]);
            int y = Integer.parseInt(args[1]);
            int z = Integer.parseInt(args[2]);
            return new BlockPos(x, y, z);
        }
        return null;
    }
}

