/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.client.screen.edit;

import com.google.common.collect.Lists;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.client.screen.base.LoadingResultHandler;
import de.melanx.skyguis.client.screen.base.list.ListScreen;
import de.melanx.skyguis.client.screen.base.list.TeamListScreen;
import de.melanx.skyguis.client.screen.notification.InformationScreen;
import de.melanx.skyguis.client.screen.notification.YouSureScreen;
import de.melanx.skyguis.client.widget.sizable.SizableButton;
import de.melanx.skyguis.network.handler.AnswerInvitation;
import de.melanx.skyguis.util.ComponentBuilder;
import de.melanx.skyguis.util.LoadingResult;
import de.melanx.skyguis.util.TextHelper;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.level.Level;
import org.moddingx.libx.impl.config.gui.screen.widget.TextWidget;
import org.moddingx.libx.screen.Panel;

public class HandleInvitationsScreen
extends TeamListScreen
implements LoadingResultHandler {
    public static final Component TITLE = ComponentBuilder.title("invitations", new Object[0]);

    public HandleInvitationsScreen() {
        super(TITLE, HandleInvitationsScreen.collectInvited(), 200, 230, new ListScreen.ScrollbarInfo(180, 10, 210), new ListScreen.RenderAreaInfo(10, 50, 160));
    }

    public static void open() {
        Minecraft.m_91087_().m_91152_((Screen)new HandleInvitationsScreen());
    }

    @Override
    public void onLoadingResult(LoadingResult result) {
        if (result.status() == LoadingResult.Status.SUCCESS) {
            Minecraft.m_91087_().m_91152_(null);
        }
        Minecraft minecraft = Minecraft.m_91087_();
        minecraft.pushGuiLayer((Screen)new InformationScreen(result.reason(), TextHelper.stringLength((FormattedText)result.reason()) + 30, 100, () -> ((Minecraft)minecraft).popGuiLayer()));
    }

    @Override
    protected void fillWidgets() {
        Minecraft minecraft = Minecraft.m_91087_();
        for (int i = 0; i < this.values.size(); ++i) {
            this.renderArea.addRenderableWidget2(new JoinTeamWidget((Team)this.values.get(i), this, 0, 14 * i, 100, 12, team -> minecraft.pushGuiLayer((Screen)new YouSureScreen(this, (Component)ComponentBuilder.text("you_sure_join", team.getName()), () -> SkyGUIs.getNetwork().handleInvitationAnswer(team.getName(), AnswerInvitation.Type.ACCEPT))), team -> minecraft.pushGuiLayer((Screen)new YouSureScreen(this, (Component)ComponentBuilder.text("you_sure_ignore", team.getName()), () -> {
                SkyGUIs.getNetwork().handleInvitationAnswer(team.getName(), AnswerInvitation.Type.IGNORE);
                Minecraft.m_91087_().m_91152_((Screen)new HandleInvitationsScreen());
            }))));
        }
    }

    private static List<Team> collectInvited() {
        Minecraft minecraft = Minecraft.m_91087_();
        SkyblockSavedData data = SkyblockSavedData.get((Level)minecraft.f_91073_);
        List invites = data.getInvites(minecraft.f_91074_.m_36316_().getId());
        if (invites == null) {
            return Lists.newArrayList();
        }
        return invites.stream().map(arg_0 -> ((SkyblockSavedData)data).getTeam(arg_0)).collect(Collectors.toList());
    }

    private static class JoinTeamWidget
    extends Panel {
        public JoinTeamWidget(Team team, Screen screen, int x, int y, int width, int height, Consumer<Team> onJoin, Consumer<Team> onIgnore) {
            super(screen, x, y, width, height);
            this.addRenderableWidget((GuiEventListener)new SizableButton(0, 0, 30, height, (Component)Component.m_237113_((String)"Join"), button -> onJoin.accept(team)));
            this.addRenderableWidget((GuiEventListener)new SizableButton(33, 0, 30, height, (Component)Component.m_237113_((String)"Ignore"), button -> onIgnore.accept(team)));
            this.addRenderableOnly((Widget)new TextWidget(screen, 66, 0, Math.min(width, TextHelper.stringLength(team.getName())), height, (Component)Component.m_237113_((String)team.getName()), (List)Lists.newArrayList()));
        }
    }
}

