/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.client.screen.base.list;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import de.melanx.skyguis.client.screen.BaseScreen;
import de.melanx.skyguis.client.widget.RenderArea;
import de.melanx.skyguis.client.widget.ScrollbarWidget;
import de.melanx.skyguis.client.widget.sizable.SizeableCheckbox;
import de.melanx.skyguis.util.ComponentBuilder;
import de.melanx.skyguis.util.TextHelper;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import org.moddingx.libx.impl.config.gui.screen.widget.TextWidget;
import org.moddingx.libx.screen.Panel;

public abstract class ListScreen<T>
extends BaseScreen {
    protected static final Component SELECT_ALL = ComponentBuilder.text("select_all", new Object[0]);
    protected static final Component UNSELECT_ALL = ComponentBuilder.text("unselect_all", new Object[0]);
    protected static final int ENTRY_HEIGHT = 14;
    private final ScrollbarInfo scrollbarInfo;
    private final RenderAreaInfo renderAreaInfo;
    private final Set<CheckboxTextWidget> widgets = new HashSet<CheckboxTextWidget>();
    protected final List<T> values;
    protected RenderArea renderArea;
    protected ScrollbarWidget scrollbar;
    private final List<Pair<PoseStack.Pose, Runnable>> capturedTooltips = new LinkedList<Pair<PoseStack.Pose, Runnable>>();
    private boolean isCapturingTooltips = false;

    public ListScreen(Component title, Set<T> values, int xSize, int ySize, ScrollbarInfo scrollbarInfo, RenderAreaInfo renderAreaInfo) {
        this(title, values.stream().toList(), xSize, ySize, scrollbarInfo, renderAreaInfo);
    }

    public ListScreen(Component title, List<T> values, int xSize, int ySize, ScrollbarInfo scrollbarInfo, RenderAreaInfo renderAreaInfo) {
        super(title, xSize, ySize);
        this.values = values;
        this.scrollbarInfo = scrollbarInfo;
        this.renderAreaInfo = renderAreaInfo;
    }

    protected void m_7856_() {
        this.widgets.clear();
        this.scrollbar = new ScrollbarWidget(this, this.scrollbarInfo.x, this.scrollbarInfo.y, 12, this.scrollbarInfo.height);
        this.renderArea = (RenderArea)this.m_7787_((GuiEventListener)new RenderArea(this, this.x(this.renderAreaInfo.x), this.y(this.renderAreaInfo.y), this.renderAreaInfo.width, this.entriesPerPage() * 14, this.xSize - 20, this.values.size() * 14, 14){

            @Override
            public void m_6305_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
                ListScreen.this.isCapturingTooltips = true;
                super.m_6305_(poseStack, mouseX, mouseY, partialTick);
                ListScreen.this.isCapturingTooltips = false;
                ListScreen.this.capturedTooltips.forEach(pair -> {
                    int x = mouseX - this.getInitX();
                    int y = mouseY - this.getInitY();
                    if (x > 0 && x < this.getRenderWidth() && y > 0 && y < this.getRenderHeight()) {
                        poseStack.m_85836_();
                        poseStack.m_166856_();
                        poseStack.m_166854_(((PoseStack.Pose)pair.getLeft()).m_85861_());
                        ((Runnable)pair.getRight()).run();
                        poseStack.m_85849_();
                    }
                });
                ListScreen.this.capturedTooltips.clear();
            }
        });
        this.fillWidgets();
        this.scrollbar.addListener(this.renderArea);
        this.updateScrollbar();
    }

    protected CheckboxTextWidget addCheckboxWidget(CheckboxTextWidget widget) {
        this.widgets.add(widget);
        return widget;
    }

    protected abstract int entriesPerPage();

    protected abstract void fillWidgets();

    public boolean allSelected() {
        for (CheckboxTextWidget widget : this.widgets) {
            if (widget.selected()) continue;
            return false;
        }
        return true;
    }

    public void selectAll() {
        for (CheckboxTextWidget widget : this.widgets) {
            widget.checkbox.f_93822_ = true;
        }
    }

    public void unselectAll() {
        for (CheckboxTextWidget widget : this.widgets) {
            widget.checkbox.f_93822_ = false;
        }
    }

    public Set<T> getSelectedValues() {
        HashSet ids = new HashSet();
        for (CheckboxTextWidget widget : this.widgets) {
            if (!widget.selected()) continue;
            ids.add(widget.getValue());
        }
        return ids;
    }

    @Override
    public void render_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        super.render_(poseStack, mouseX, mouseY, partialTick);
        this.renderTitle(poseStack);
        this.scrollbar.render(poseStack);
        this.renderArea.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return this.scrollbar.m_6375_(mouseX, mouseY, button) || super.m_6375_(mouseX, mouseY, button);
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.scrollbar.m_94757_(mouseX, mouseY);
        super.m_94757_(mouseX, mouseY);
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return this.scrollbar.m_6348_(mouseX, mouseY, button) || super.m_6348_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        return this.scrollbar.m_6050_(mouseX, mouseY, delta) || super.m_6050_(mouseX, mouseY, delta);
    }

    public void updateScrollbar() {
        this.scrollbar.setEnabled(this.values.size() > this.entriesPerPage());
        this.scrollbar.setMaxOffset(this.values.size() - this.entriesPerPage());
    }

    public List<T> getValues() {
        return ImmutableList.copyOf(this.values);
    }

    private void captureTooltip(PoseStack.Pose pose, Runnable action) {
        this.capturedTooltips.add((Pair<PoseStack.Pose, Runnable>)Pair.of((Object)pose, (Object)action));
    }

    protected void m_6057_(@Nonnull PoseStack poseStack, @Nonnull ItemStack stack, int x, int y) {
        if (this.isCapturingTooltips) {
            this.captureTooltip(poseStack.m_85850_(), () -> this.m_6057_(poseStack, stack, x, y));
        } else {
            super.m_6057_(poseStack, stack, x, y);
        }
    }

    public void m_169388_(@Nonnull PoseStack poseStack, @Nonnull List<Component> tooltip, @Nonnull Optional<TooltipComponent> special, int x, int y) {
        if (this.isCapturingTooltips) {
            this.captureTooltip(poseStack.m_85850_(), () -> this.m_169388_(poseStack, tooltip, special, x, y));
        } else {
            super.m_169388_(poseStack, tooltip, special, x, y);
        }
    }

    public void m_96602_(@Nonnull PoseStack poseStack, @Nonnull Component tooltip, int x, int y) {
        if (this.isCapturingTooltips) {
            this.captureTooltip(poseStack.m_85850_(), () -> this.m_96602_(poseStack, tooltip, x, y));
        } else {
            super.m_96602_(poseStack, tooltip, x, y);
        }
    }

    public void m_96597_(@Nonnull PoseStack poseStack, @Nonnull List<Component> tooltip, int x, int y) {
        if (this.isCapturingTooltips) {
            this.captureTooltip(poseStack.m_85850_(), () -> this.m_96597_(poseStack, tooltip, x, y));
        } else {
            super.m_96597_(poseStack, tooltip, x, y);
        }
    }

    public void m_96617_(@Nonnull PoseStack poseStack, @Nonnull List<? extends FormattedCharSequence> tooltip, int x, int y) {
        if (this.isCapturingTooltips) {
            this.captureTooltip(poseStack.m_85850_(), () -> this.m_96617_(poseStack, tooltip, x, y));
        } else {
            super.m_96617_(poseStack, tooltip, x, y);
        }
    }

    public void renderTooltip(@Nonnull PoseStack poseStack, @Nonnull List<Component> tooltip, @Nonnull Optional<TooltipComponent> tooltipComponent, int x, int y, @Nonnull ItemStack stack) {
        if (this.isCapturingTooltips) {
            this.captureTooltip(poseStack.m_85850_(), () -> this.renderTooltip(poseStack, tooltip, tooltipComponent, x, y, stack));
        } else {
            super.renderTooltip(poseStack, tooltip, tooltipComponent, x, y, stack);
        }
    }

    public void renderTooltip(@Nonnull PoseStack poseStack, @Nonnull List<Component> tooltip, @Nonnull Optional<TooltipComponent> tooltipComponent, int x, int y, @Nullable Font font) {
        if (this.isCapturingTooltips) {
            this.captureTooltip(poseStack.m_85850_(), () -> this.renderTooltip(poseStack, tooltip, tooltipComponent, x, y, font));
        } else {
            super.renderTooltip(poseStack, tooltip, tooltipComponent, x, y, font);
        }
    }

    public void renderTooltip(@Nonnull PoseStack poseStack, @Nonnull List<Component> tooltip, @Nonnull Optional<TooltipComponent> tooltipComponent, int x, int y, @Nullable Font font, @Nonnull ItemStack stack) {
        if (this.isCapturingTooltips) {
            this.captureTooltip(poseStack.m_85850_(), () -> this.renderTooltip(poseStack, tooltip, tooltipComponent, x, y, font, stack));
        } else {
            super.renderTooltip(poseStack, tooltip, tooltipComponent, x, y, font, stack);
        }
    }

    public void renderComponentTooltip(@Nonnull PoseStack poseStack, @Nonnull List<? extends FormattedText> tooltip, int mouseX, int mouseY, @Nonnull ItemStack stack) {
        if (this.isCapturingTooltips) {
            this.captureTooltip(poseStack.m_85850_(), () -> this.renderComponentTooltip(poseStack, (List<FormattedText>)tooltip, mouseX, mouseY, stack));
        } else {
            super.renderComponentTooltip(poseStack, tooltip, mouseX, mouseY, stack);
        }
    }

    public void renderComponentTooltip(@Nonnull PoseStack poseStack, @Nonnull List<? extends FormattedText> tooltip, int mouseX, int mouseY, @Nullable Font font) {
        if (this.isCapturingTooltips) {
            this.captureTooltip(poseStack.m_85850_(), () -> this.renderComponentTooltip(poseStack, (List<FormattedText>)tooltip, mouseX, mouseY, font));
        } else {
            super.renderComponentTooltip(poseStack, tooltip, mouseX, mouseY, font);
        }
    }

    public void renderComponentTooltip(@Nonnull PoseStack poseStack, @Nonnull List<? extends FormattedText> tooltip, int mouseX, int mouseY, @Nullable Font font, @Nonnull ItemStack stack) {
        if (this.isCapturingTooltips) {
            this.captureTooltip(poseStack.m_85850_(), () -> this.renderComponentTooltip(poseStack, tooltip, mouseX, mouseY, font, stack));
        } else {
            super.renderComponentTooltip(poseStack, tooltip, mouseX, mouseY, font, stack);
        }
    }

    public void renderTooltip(@Nonnull PoseStack poseStack, @Nonnull List<? extends FormattedCharSequence> tooltip, int x, int y, @Nonnull Font font) {
        if (this.isCapturingTooltips) {
            this.captureTooltip(poseStack.m_85850_(), () -> this.renderTooltip(poseStack, tooltip, x, y, font));
        } else {
            super.renderTooltip(poseStack, tooltip, x, y, font);
        }
    }

    public record ScrollbarInfo(int x, int y, int height) {
    }

    public record RenderAreaInfo(int x, int y, int width, int height) {
        public RenderAreaInfo(int x, int y, int width) {
            this(x, y, width, 0);
        }
    }

    protected class CheckboxTextWidget
    extends Panel {
        protected final T value;
        protected final Checkbox checkbox;

        public CheckboxTextWidget(T value, Screen screen, int x, int y, int width, int height, Component text) {
            this(value, screen, x, y, width, height, Lists.newArrayList(), text);
        }

        public CheckboxTextWidget(T value, Screen screen, int x, int y, int width, int height, List<Component> tooltip, Component text) {
            super(screen, x, y, width, height);
            this.value = value;
            this.checkbox = new SizeableCheckbox(0, 0, height, false);
            this.addRenderableWidget((GuiEventListener)this.checkbox);
            TextWidget textWidget = new TextWidget(screen, height + 5, 0, Math.min(width, TextHelper.stringLength((FormattedText)text)), height, text, tooltip);
            this.addRenderableWidget((GuiEventListener)textWidget);
        }

        public T getValue() {
            return this.value;
        }

        public boolean selected() {
            return this.checkbox.m_93840_();
        }
    }
}

