/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyguis.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import de.melanx.skyblockbuilder.template.ConfiguredTemplate;
import de.melanx.skyblockbuilder.template.TemplateLoader;
import de.melanx.skyblockbuilder.util.NameGenerator;
import de.melanx.skyguis.SkyGUIs;
import de.melanx.skyguis.client.TemplateRenderer;
import de.melanx.skyguis.client.screen.BaseScreen;
import de.melanx.skyguis.client.screen.base.LoadingResultHandler;
import de.melanx.skyguis.client.screen.notification.InformationScreen;
import de.melanx.skyguis.util.ComponentBuilder;
import de.melanx.skyguis.util.LoadingResult;
import de.melanx.skyguis.util.TextHelper;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class CreateTeamScreen
extends BaseScreen
implements LoadingResultHandler {
    private static final Component NAME_COMPONENT = ComponentBuilder.text("name", new Object[0]);
    private static final Component TEMPLATE_COMPONENT = ComponentBuilder.raw("template", new Object[0]);
    private static final Component CREATE = ComponentBuilder.button("create", new Object[0]);
    private static final Component ABORT = ComponentBuilder.button("abort", new Object[0]);
    private static final Component TITLE = ComponentBuilder.title("create_team", new Object[0]);
    private final transient Map<String, TemplateRenderer> structureCache = new HashMap<String, TemplateRenderer>();
    private final List<String> templates = TemplateLoader.getTemplateNames();
    private String currTemplate;
    private EditBox name;
    private int currIndex = 0;
    private boolean enableTooltip;

    public CreateTeamScreen() {
        super(TITLE, 200, 125);
    }

    public static void open() {
        Minecraft.m_91087_().m_91152_((Screen)new CreateTeamScreen());
    }

    protected void m_7856_() {
        this.name = new EditBox(this.f_96547_, this.x(66), this.y(30), 120, 20, (Component)Component.m_237119_());
        this.name.m_94199_(Short.MAX_VALUE);
        this.name.m_94144_(this.name.m_94155_());
        this.m_142416_((GuiEventListener)this.name);
        if (this.templates.isEmpty()) {
            Minecraft.m_91087_().m_91152_(null);
            Minecraft.m_91087_().f_91074_.m_213846_((Component)ComponentBuilder.text("empty_templates", new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.RED}));
            return;
        }
        String original = this.templates.get(this.currIndex);
        String shortened = TextHelper.shorten(this.f_96547_, original, 110);
        this.enableTooltip = !shortened.equals(original);
        this.currTemplate = original;
        Button templateButton = new Button(this.x(65), this.y(60), 122, 20, (Component)Component.m_237113_((String)shortened), button -> {
            String orig;
            String s;
            ++this.currIndex;
            if (this.currIndex >= this.templates.size()) {
                this.currIndex = 0;
            }
            this.enableTooltip = !(s = TextHelper.shorten(this.f_96547_, orig = this.templates.get(this.currIndex), 110)).equals(orig);
            this.currTemplate = orig;
            button.m_93666_((Component)Component.m_237113_((String)s));
        }, (button, poseStack, mouseX, mouseY) -> {
            if (this.enableTooltip) {
                this.m_96602_(poseStack, (Component)Component.m_237113_((String)this.currTemplate), mouseX, mouseY);
            }
        });
        if (this.templates.size() == 1) {
            templateButton.f_93623_ = false;
        }
        this.currTemplate = this.templates.get(this.currIndex);
        this.m_142416_((GuiEventListener)templateButton);
        this.m_142416_((GuiEventListener)new Button(this.x(27), this.y(92), 60, 20, CREATE, button -> {
            if (this.name.m_94155_().isBlank()) {
                this.name.m_94178_(true);
                this.name.m_94144_(NameGenerator.randomName((Random)new Random()));
            } else {
                SkyGUIs.getNetwork().handleCreateTeam(this.name.m_94155_(), this.currTemplate);
                this.getLoadingCircle().setActive(true);
            }
        }));
        this.m_142416_((GuiEventListener)new Button(this.x(106), this.y(92), 60, 20, ABORT, button -> this.m_7379_()));
    }

    @Override
    public void m_86600_() {
        this.name.m_94120_();
        super.m_86600_();
    }

    @Override
    public void render_(@Nonnull PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        super.render_(poseStack, mouseX, mouseY, partialTick);
        this.renderTitle(poseStack);
        this.f_96547_.m_92889_(poseStack, NAME_COMPONENT, (float)this.x(10), (float)this.y(37), Color.DARK_GRAY.getRGB());
        this.f_96547_.m_92889_(poseStack, TEMPLATE_COMPONENT, (float)this.x(10), (float)this.y(67), Color.DARK_GRAY.getRGB());
        if (!this.structureCache.containsKey(this.currTemplate)) {
            SkyGUIs.getNetwork().requestTemplateFromServer(this.currTemplate);
            this.structureCache.put(this.currTemplate, null);
            return;
        }
        TemplateRenderer renderer = this.structureCache.get(this.currTemplate);
        if (renderer != null) {
            renderer.render(poseStack, this.f_96543_ / 6, this.centeredY(0));
        }
    }

    @Override
    public void onLoadingResult(LoadingResult result) {
        switch (result.status()) {
            case SUCCESS: {
                this.m_7379_();
                break;
            }
            case FAIL: {
                Minecraft minecraft = Minecraft.m_91087_();
                minecraft.pushGuiLayer((Screen)new InformationScreen(result.reason(), TextHelper.stringLength((FormattedText)result.reason()) + 30, 100, () -> ((Minecraft)minecraft).popGuiLayer()));
            }
        }
    }

    public void addStructureToCache(String name, ConfiguredTemplate template) {
        this.structureCache.put(name, new TemplateRenderer(template.getTemplate(), 130.0f));
    }
}

