/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.simplyharvesting;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class EventListener {
    @SubscribeEvent
    public void onRightclickBlock(PlayerInteractEvent.RightClickBlock event) {
        Age age;
        BlockHitResult hitResult = event.getHitVec();
        BlockPos pos = hitResult.getBlockPos();
        BlockState state = event.getLevel().getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof CropBlock) {
            CropBlock crop = (CropBlock)block;
            v0 = new Age(crop.getAgeProperty(), crop.getMaxAge());
        } else {
            v0 = age = block instanceof CocoaBlock ? new Age(CocoaBlock.AGE, 2) : null;
        }
        if (age == null) {
            for (Property property : state.getProperties()) {
                IntegerProperty integerProperty;
                if (!(property instanceof IntegerProperty) || !(integerProperty = (IntegerProperty)property).getName().equals("age")) continue;
                age = new Age(integerProperty, integerProperty.max);
                break;
            }
        }
        if (age != null && (Integer)state.getValue((Property)age.property) == age.maxAge) {
            Level level = event.getLevel();
            EventListener.dropLoot(level, event.getEntity(), state, pos, age);
            SoundType soundType = block.getSoundType(state, (LevelReader)level, pos, (Entity)event.getEntity());
            level.playSound((Entity)event.getEntity(), pos, soundType.getBreakSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
            level.addDestroyBlockEffect(pos, state);
            UseOnContext useOnContext = new UseOnContext(event.getEntity(), event.getHand(), hitResult);
            event.getItemStack().onItemUseFirst(useOnContext);
            event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    private static void dropLoot(Level level, Player player, BlockState state, BlockPos pos, Age age) {
        if (level.isClientSide()) {
            return;
        }
        Optional lootTableKey = state.getBlock().getLootTable();
        if (lootTableKey.isEmpty()) {
            return;
        }
        LootTable lootTable = level.getServer().reloadableRegistries().getLootTable((ResourceKey)lootTableKey.get());
        ObjectArrayList drops = lootTable.getRandomItems(new LootParams.Builder((ServerLevel)level).withParameter(LootContextParams.THIS_ENTITY, (Object)player).withParameter(LootContextParams.BLOCK_STATE, (Object)state).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).create(LootContextParamSets.BLOCK));
        level.setBlock(pos, (BlockState)state.setValue((Property)age.property, (Comparable)Integer.valueOf(0)), 3);
        for (ItemStack drop : drops) {
            if (drop.getItem() instanceof BlockItem) {
                drop.shrink(1);
            }
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)drop);
        }
    }

    private record Age(IntegerProperty property, int maxAge) {
    }
}

