/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.simplebackups;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.melanx.simplebackups.BackupData;
import de.melanx.simplebackups.BackupThread;
import de.melanx.simplebackups.SimpleBackups;
import de.melanx.simplebackups.commands.BackupCommand;
import de.melanx.simplebackups.commands.MergeCommand;
import de.melanx.simplebackups.commands.PauseCommand;
import de.melanx.simplebackups.config.CommonConfig;
import de.melanx.simplebackups.config.ServerConfig;
import de.melanx.simplebackups.network.Pause;
import net.minecraft.commands.Commands;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.registration.NetworkRegistry;

public class EventListener {
    private boolean doBackup;

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"simplebackups").requires(stack -> ServerConfig.commandsCheatsDisabled() || stack.hasPermission(2))).then(BackupCommand.register())).then(PauseCommand.register())).then(MergeCommand.register()));
    }

    @SubscribeEvent
    public void onServerTick(LevelTickEvent.Post event) {
        ServerLevel level;
        if (!CommonConfig.backupsDisabledByJvmArg()) {
            return;
        }
        Level level2 = event.getLevel();
        if (level2 instanceof ServerLevel && !(level = (ServerLevel)level2).isClientSide() && level.getGameTime() % 20L == 0L && level == level.getServer().overworld()) {
            boolean arePlayersOnline;
            EventListener.checkForTickCounterConfigUpdate(event.getLevel().getServer());
            boolean bl = arePlayersOnline = !level.getServer().getPlayerList().getPlayers().isEmpty();
            if (arePlayersOnline || this.doBackup || CommonConfig.doNoPlayerBackups()) {
                BackupData backupData = BackupData.get(level);
                this.doBackup = CommonConfig.noPlayerBackupCount() != 0 && backupData.backupsSinceLastPlayerJoined() < CommonConfig.noPlayerBackupCount();
                boolean done = BackupThread.tryCreateBackup(level.getServer());
                if (done) {
                    SimpleBackups.LOGGER.info("Backup done.");
                    if (!arePlayersOnline) {
                        backupData.incrementBackupsSinceLastPlayerJoined();
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerConnect(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        BackupData.get(player.level()).resetBackupsSinceLastPlayerJoined();
        if (CommonConfig.isEnabled() && !CommonConfig.backupsDisabledByJvmArg() && NetworkRegistry.hasChannel((Connection)player.connection.connection, null, (ResourceLocation)Pause.ID)) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new Pause(BackupData.get(player.level().getServer()).isPaused()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && (player = (ServerPlayer)player2).level().getServer().getPlayerList().getPlayers().isEmpty()) {
            this.doBackup = CommonConfig.noPlayerBackupCount() != 0 && BackupData.get(player.level()).backupsSinceLastPlayerJoined() < CommonConfig.noPlayerBackupCount();
        }
    }

    private static void checkForTickCounterConfigUpdate(MinecraftServer server) {
        BackupData backupData = BackupData.get(server);
        boolean usesTickCounter = CommonConfig.useTickCounter();
        if (usesTickCounter != backupData.usesTickCounter()) {
            SimpleBackups.LOGGER.info("Tick counter config updated, usesTickCounter: {}", (Object)usesTickCounter);
            backupData.setUsesTickCounter(usesTickCounter);
            long lastTimeSaved = backupData.getLastSaved();
            long commonConfigTimer = CommonConfig.getTimer(true);
            SimpleBackups.LOGGER.info("Initial lastTimeSaved: {}", (Object)lastTimeSaved);
            SimpleBackups.LOGGER.info("Config timer in minutes: {}", (Object)commonConfigTimer);
            if (usesTickCounter) {
                long millisecondsTimeDifference = System.currentTimeMillis() - lastTimeSaved;
                long tickTimeDifference = millisecondsTimeDifference / 50L;
                lastTimeSaved = server.overworld().getGameTime() - tickTimeDifference;
                long timerInTicks = commonConfigTimer * 60L * 20L;
                SimpleBackups.LOGGER.info("Milliseconds difference: {}, Tick difference: {}", (Object)millisecondsTimeDifference, (Object)tickTimeDifference);
                SimpleBackups.LOGGER.info("Updated lastTimeSaved in ticks: {}", (Object)lastTimeSaved);
                SimpleBackups.LOGGER.info("Timer value in ticks: {}", (Object)timerInTicks);
                lastTimeSaved = Math.max(lastTimeSaved, timerInTicks);
                SimpleBackups.LOGGER.info("Final lastTimeSaved after max comparison (ticks): {}", (Object)lastTimeSaved);
            } else {
                long tickTimeDifference = server.overworld().getGameTime() - lastTimeSaved;
                long millisecondsTimeDifference = tickTimeDifference * 50L;
                lastTimeSaved = System.currentTimeMillis() - millisecondsTimeDifference;
                long timerInMilliseconds = commonConfigTimer * 60L * 1000L;
                SimpleBackups.LOGGER.info("Tick difference: {}, Milliseconds difference: {}", (Object)tickTimeDifference, (Object)millisecondsTimeDifference);
                SimpleBackups.LOGGER.info("Updated lastTimeSaved in milliseconds: {}", (Object)lastTimeSaved);
                SimpleBackups.LOGGER.info("Timer value in milliseconds: {}", (Object)timerInMilliseconds);
                lastTimeSaved = Math.max(lastTimeSaved, timerInMilliseconds);
                SimpleBackups.LOGGER.info("Final lastTimeSaved after max comparison (milliseconds): {}", (Object)lastTimeSaved);
            }
        }
    }
}

