/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.simplebackups;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.melanx.simplebackups.config.CommonConfig;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;

public class BackupData
extends SavedData {
    private long lastSaved;
    private long lastFullBackup;
    private boolean paused;
    private boolean merging;
    private boolean usesTickCounter;
    public static final Codec<BackupData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("lastSaved").forGetter(BackupData::getLastSaved), (App)Codec.LONG.fieldOf("lastFullBackup").forGetter(BackupData::getLastFullBackup), (App)Codec.BOOL.fieldOf("paused").forGetter(BackupData::isPaused), (App)Codec.BOOL.fieldOf("merging").forGetter(BackupData::isMerging), (App)Codec.BOOL.fieldOf("usesTickCounter").forGetter(BackupData::usesTickCounter)).apply((Applicative)instance, BackupData::new));

    public static SavedDataType<BackupData> type() {
        return new SavedDataType("simplebackups", context -> new BackupData(0L, 0L, false, false, CommonConfig.useTickCounter()), context -> CODEC);
    }

    private BackupData(long lastSaved, long lastFullBackup, boolean paused, boolean merging, boolean usesTickCounter) {
        this.lastSaved = lastSaved;
        this.lastFullBackup = lastFullBackup;
        this.paused = paused;
        this.merging = merging;
        this.usesTickCounter = usesTickCounter;
    }

    public static BackupData get(ServerLevel level) {
        return BackupData.get(level.getServer());
    }

    public static BackupData get(MinecraftServer server) {
        return (BackupData)server.overworld().getDataStorage().computeIfAbsent(BackupData.type());
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
        this.setDirty();
    }

    public boolean isPaused() {
        return this.paused;
    }

    public long getLastSaved() {
        return this.lastSaved;
    }

    public void updateSaveTime(long time) {
        this.lastSaved = time;
        this.setDirty();
    }

    public long getLastFullBackup() {
        return this.lastFullBackup;
    }

    public void updateFullBackupTime(long time) {
        this.lastFullBackup = time;
        this.setDirty();
    }

    public boolean isMerging() {
        return this.merging;
    }

    public void startMerging() {
        this.merging = true;
    }

    public void stopMerging() {
        this.merging = false;
    }

    public boolean usesTickCounter() {
        return this.usesTickCounter;
    }

    public void setUsesTickCounter(boolean usesTickCounter) {
        this.usesTickCounter = usesTickCounter;
        this.setDirty();
    }
}

