/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.simplebackups;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.melanx.simplebackups.SimpleBackups;
import de.melanx.simplebackups.config.BackupType;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;

public class BackupChain {
    public static final String METADATA_FILE = "metadata.json";
    private final Path parentFolder;
    private final Path fullBackup;
    private final List<Path> children;
    private final BackupType backupType;
    private long lastUpdated;

    public BackupChain(Path parentFolder, Path fullBackup, BackupType backupType) {
        this(parentFolder, fullBackup, new ArrayList<Path>(), backupType, System.currentTimeMillis());
    }

    public BackupChain(Path parentFolder, Path fullBackup, List<Path> children, BackupType backupType, long lastUpdated) {
        this.parentFolder = parentFolder;
        this.fullBackup = fullBackup;
        this.children = children;
        this.backupType = backupType;
        this.lastUpdated = lastUpdated;
    }

    public Path getParentFolder() {
        return this.parentFolder;
    }

    public Path getFullBackup() {
        return this.parentFolder.resolve(this.fullBackup);
    }

    public List<Path> getChildren() {
        return this.children.stream().map(this.parentFolder::resolve).toList();
    }

    public BackupType getBackupType() {
        return this.backupType;
    }

    public void addChild(Path child) {
        this.children.add(child);
    }

    public Path createChild() {
        int index = this.children.size() + 1;
        Path child = Path.of("child-" + String.format("%04d", index) + ".zip", new String[0]);
        this.children.add(child);
        this.lastUpdated = System.currentTimeMillis();
        this.writeMetadata();
        return this.parentFolder.resolve(child);
    }

    public long getLastUpdated() {
        return this.lastUpdated;
    }

    public long getFileSize() {
        try {
            return Files.walk(this.parentFolder, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).mapToLong(path -> {
                try {
                    return Files.size(path);
                }
                catch (IOException e) {
                    SimpleBackups.LOGGER.warn("Failed to get size of {}", path, (Object)e);
                    return 0L;
                }
            }).sum();
        }
        catch (IOException e) {
            SimpleBackups.LOGGER.warn("Failed to get size of {}", (Object)this.parentFolder, (Object)e);
            return 0L;
        }
    }

    public void deleteFiles() {
        if (!Files.exists(this.parentFolder, new LinkOption[0])) {
            return;
        }
        try {
            Files.walk(this.parentFolder, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(path -> {
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException e) {
                    SimpleBackups.LOGGER.warn("Failed to delete \"{}\"", path, (Object)e);
                }
            });
            Files.deleteIfExists(this.parentFolder);
        }
        catch (IOException e) {
            SimpleBackups.LOGGER.warn("Failed to delete directory tree \"{}\"", (Object)this.parentFolder, (Object)e);
        }
    }

    public int getSize() {
        return this.children.size() + 1;
    }

    public void writeMetadata() {
        Path meta = this.parentFolder.resolve(METADATA_FILE);
        JsonObject json = new JsonObject();
        json.addProperty("backupType", this.getBackupType().name());
        json.addProperty("fullBackup", this.fullBackup.toString());
        JsonArray children = new JsonArray();
        for (Path child : this.children) {
            children.add(child.toString());
        }
        json.add("children", (JsonElement)children);
        json.addProperty("lastUpdated", (Number)this.lastUpdated);
        try {
            Files.writeString(meta, (CharSequence)json.toString(), new OpenOption[0]);
        }
        catch (IOException e) {
            SimpleBackups.LOGGER.warn("Failed to write metadata to {}", (Object)meta, (Object)e);
        }
    }

    @Nullable
    public static BackupChain readMetadata(Path chainDir) {
        Path meta = chainDir.resolve(METADATA_FILE);
        try {
            JsonObject json = (JsonObject)new Gson().fromJson((Reader)Files.newBufferedReader(meta), JsonObject.class);
            Path fullBackup = Path.of(json.get("fullBackup").getAsString(), new String[0]);
            ArrayList<Path> children = new ArrayList<Path>();
            for (JsonElement child : json.getAsJsonArray("children")) {
                children.add(Path.of(child.getAsString(), new String[0]));
            }
            BackupType backupType = BackupType.valueOf(json.get("backupType").getAsString());
            long lastUpdated = json.get("lastUpdated").getAsLong();
            return new BackupChain(chainDir, fullBackup, children, backupType, lastUpdated);
        }
        catch (IOException e) {
            SimpleBackups.LOGGER.warn("Failed to read metadata from {}", (Object)meta, (Object)e);
            return null;
        }
    }
}

