/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.simplebackups;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.melanx.simplebackups.BackupData;
import de.melanx.simplebackups.BackupThread;
import de.melanx.simplebackups.SimpleBackups;
import de.melanx.simplebackups.commands.BackupCommand;
import de.melanx.simplebackups.commands.MergeCommand;
import de.melanx.simplebackups.commands.PauseCommand;
import de.melanx.simplebackups.config.CommonConfig;
import de.melanx.simplebackups.config.ServerConfig;
import net.minecraft.commands.Commands;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventListener {
    private boolean doBackup;

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"simplebackups").requires(stack -> ServerConfig.commandsCheatsDisabled() || stack.m_6761_(2))).then(BackupCommand.register())).then(PauseCommand.register())).then(MergeCommand.register()));
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.LevelTickEvent event) {
        if (!CommonConfig.backupsDisabledByJvmArg()) {
            return;
        }
        if (event.phase == TickEvent.Phase.END && !event.level.f_46443_ && event.level.m_46467_() % 20L == 0L && event.level == event.level.m_7654_().m_129783_()) {
            EventListener.checkForTickCounterConfigUpdate(event.level.m_7654_());
            if (!event.level.m_7654_().m_6846_().m_11314_().isEmpty() || this.doBackup || CommonConfig.doNoPlayerBackups()) {
                this.doBackup = false;
                boolean done = BackupThread.tryCreateBackup(event.level.m_7654_());
                if (done) {
                    SimpleBackups.LOGGER.info("Backup done.");
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerConnect(PlayerEvent.PlayerLoggedInEvent event) {
        if (CommonConfig.isEnabled() && !CommonConfig.backupsDisabledByJvmArg() && event.getEntity().m_20194_() != null) {
            SimpleBackups.network().pause(event.getEntity(), BackupData.get(event.getEntity().m_20194_()).isPaused());
        }
    }

    @SubscribeEvent
    public void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && (player = (ServerPlayer)player2).m_20194_().m_6846_().m_11314_().isEmpty()) {
            this.doBackup = true;
        }
    }

    private static void checkForTickCounterConfigUpdate(MinecraftServer server) {
        BackupData backupData = BackupData.get(server);
        boolean usesTickCounter = CommonConfig.useTickCounter();
        if (usesTickCounter != backupData.usesTickCounter()) {
            SimpleBackups.LOGGER.info("Tick counter config updated, usesTickCounter: {}", (Object)usesTickCounter);
            backupData.setUsesTickCounter(usesTickCounter);
            long lastTimeSaved = backupData.getLastSaved();
            long commonConfigTimer = CommonConfig.getTimer();
            SimpleBackups.LOGGER.info("Initial lastTimeSaved: {}", (Object)lastTimeSaved);
            SimpleBackups.LOGGER.info("Config timer in minutes: {}", (Object)commonConfigTimer);
            if (usesTickCounter) {
                long millisecondsTimeDifference = System.currentTimeMillis() - lastTimeSaved;
                long tickTimeDifference = millisecondsTimeDifference / 50L;
                lastTimeSaved = server.m_129783_().m_46467_() - tickTimeDifference;
                long timerInTicks = commonConfigTimer * 60L * 20L;
                SimpleBackups.LOGGER.info("Milliseconds difference: {}, Tick difference: {}", (Object)millisecondsTimeDifference, (Object)tickTimeDifference);
                SimpleBackups.LOGGER.info("Updated lastTimeSaved in ticks: {}", (Object)lastTimeSaved);
                SimpleBackups.LOGGER.info("Timer value in ticks: {}", (Object)timerInTicks);
                lastTimeSaved = Math.max(lastTimeSaved, timerInTicks);
                SimpleBackups.LOGGER.info("Final lastTimeSaved after max comparison (ticks): {}", (Object)lastTimeSaved);
            } else {
                long tickTimeDifference = server.m_129783_().m_46467_() - lastTimeSaved;
                long millisecondsTimeDifference = tickTimeDifference * 50L;
                lastTimeSaved = System.currentTimeMillis() - millisecondsTimeDifference;
                long timerInMilliseconds = commonConfigTimer * 60L * 1000L;
                SimpleBackups.LOGGER.info("Tick difference: {}, Milliseconds difference: {}", (Object)tickTimeDifference, (Object)millisecondsTimeDifference);
                SimpleBackups.LOGGER.info("Updated lastTimeSaved in milliseconds: {}", (Object)lastTimeSaved);
                SimpleBackups.LOGGER.info("Timer value in milliseconds: {}", (Object)timerInMilliseconds);
                lastTimeSaved = Math.max(lastTimeSaved, timerInMilliseconds);
                SimpleBackups.LOGGER.info("Final lastTimeSaved after max comparison (milliseconds): {}", (Object)lastTimeSaved);
            }
        }
    }
}

