/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.simplebackups.config;

import de.melanx.simplebackups.StorageSize;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfig {
    public static final ForgeConfigSpec CONFIG;
    private static final ForgeConfigSpec.Builder BUILDER;
    private static ForgeConfigSpec.BooleanValue enabled;
    private static ForgeConfigSpec.BooleanValue onlyModified;
    private static ForgeConfigSpec.BooleanValue saveAll;
    private static ForgeConfigSpec.IntValue fullBackupTimer;
    private static ForgeConfigSpec.IntValue backupsToKeep;
    private static ForgeConfigSpec.IntValue timer;
    private static ForgeConfigSpec.IntValue compressionLevel;
    private static ForgeConfigSpec.BooleanValue sendMessages;
    private static ForgeConfigSpec.ConfigValue<String> maxDiskSize;
    private static ForgeConfigSpec.ConfigValue<String> outputPath;
    private static ForgeConfigSpec.BooleanValue createSubDirs;
    private static ForgeConfigSpec.BooleanValue mc2discord;

    public static void init(ForgeConfigSpec.Builder builder) {
        enabled = builder.comment("If set false, no backups are being made.").define("enabled", true);
        onlyModified = builder.comment("Should only changed files be backed up? Useful for large worlds. Keep in mind that old backups are required for a complete backup. Alternatively, you could run the command to create a new complete backup.").define("onlyModified", false);
        saveAll = builder.comment("Should a save-all be forced before backup?").define("saveAll", true);
        fullBackupTimer = builder.comment("How often should a full backup be created if only modified files should be saved? This creates a full backup when x minutes are over and the next backup needs to be done. Once a year is default.").defineInRange("fullBackupTimer", 525960, 1, 5259600);
        backupsToKeep = builder.comment("The max amount of backup files to keep.").defineInRange("backupsToKeep", 10, 1, Short.MAX_VALUE);
        timer = builder.comment(new String[]{"The time between two backups in minutes", "5 = each 5 minutes", "60 = each hour", "1440 = each day"}).defineInRange("timer", 120, 1, Short.MAX_VALUE);
        compressionLevel = builder.comment("The compression level, 0 is no compression (less cpu usage) and takes a lot of space, 9 is best compression (most cpu usage) and takes less space. -1 is default").defineInRange("compressionLevel", -1, Math.min(-1, 0), 9);
        sendMessages = builder.comment("Should message be sent when backup is in the making?").define("sendMessages", true);
        maxDiskSize = builder.comment(new String[]{"The max size of storage the backup folder. If it takes more storage, old files will be deleted.", "Needs to be written as <number><space><storage type>", "Valid storage types: B, KB, MB, GB, TB"}).define("maxDiskSize", (Object)"25 GB");
        outputPath = builder.comment("Used to define the output path.").define("outputPath", (Object)"simplebackups");
        createSubDirs = builder.comment(new String[]{"Should sub-directories be generated for each world?", "Keep in mind that all configs above, including backupsToKeep and maxDiskSize, will be calculated for each sub directory."}).define("createSubDirs", false);
        builder.push("mod_compat");
        mc2discord = builder.comment("Should backup notifications be sent to Discord by using mc2discord? (needs to be installed)").define("mc2discord", true);
        builder.pop();
    }

    public static boolean isEnabled() {
        return (Boolean)enabled.get();
    }

    public static int getBackupsToKeep() {
        return (Integer)backupsToKeep.get();
    }

    public static int getTimer() {
        return (Integer)timer.get() * 60 * 1000;
    }

    public static int getFullBackupTimer() {
        return (Integer)fullBackupTimer.get() * 60 * 1000;
    }

    public static int getCompressionLevel() {
        return (Integer)compressionLevel.get();
    }

    public static long getMaxDiskSize() {
        String s = (String)maxDiskSize.get();
        if (s.split(" ").length != 2) {
            s = "25 GB";
        }
        return StorageSize.getBytes(s);
    }

    @Deprecated(forRemoval=true)
    public static Path getOutputPath() {
        return CommonConfig.getOutputPath(null);
    }

    public static Path getOutputPath(@Nullable String levelId) {
        Path base = Paths.get((String)outputPath.get(), new String[0]);
        boolean withSubDir = levelId != null && !levelId.isEmpty() && (Boolean)createSubDirs.get() != false;
        try {
            return withSubDir ? base.toRealPath(new LinkOption[0]).resolve(levelId) : base.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            return withSubDir ? base.resolve(levelId) : base;
        }
    }

    public static boolean onlyModified() {
        return (Boolean)onlyModified.get();
    }

    public static boolean saveAll() {
        return (Boolean)saveAll.get();
    }

    public static boolean sendMessages() {
        return (Boolean)sendMessages.get();
    }

    public static boolean mc2discord() {
        return (Boolean)mc2discord.get();
    }

    static {
        BUILDER = new ForgeConfigSpec.Builder();
        CommonConfig.init(BUILDER);
        CONFIG = BUILDER.build();
    }
}

