/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.jea;

import de.melanx.jea.JustEnoughAdvancements;
import de.melanx.jea.config.JeaConfig;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.moddingx.libx.event.ConfigLoadedEvent;

public class EventHandler {
    private boolean needsResyncAdvancements = false;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            JustEnoughAdvancements.getNetwork().syncAdvancements(serverPlayer.serverLevel().getServer(), serverPlayer);
        }
    }

    @SubscribeEvent
    public void resourcesReload(OnDatapackSyncEvent event) {
        if (event.getPlayer() == null) {
            JustEnoughAdvancements.getNetwork().syncAdvancements(event.getPlayerList().getServer());
        } else {
            JustEnoughAdvancements.getNetwork().syncAdvancements(event.getPlayerList().getServer(), event.getPlayer());
        }
    }

    @SubscribeEvent
    public void serverTick(ServerTickEvent.Post event) {
        if (this.needsResyncAdvancements) {
            this.needsResyncAdvancements = false;
            JustEnoughAdvancements.getNetwork().syncAdvancements(event.getServer());
        }
    }

    @SubscribeEvent
    public void configReload(ConfigLoadedEvent event) {
        if (event.getConfigClass() == JeaConfig.class && event.getReason() == ConfigLoadedEvent.LoadReason.RELOAD) {
            this.needsResyncAdvancements = true;
        }
    }
}

