/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.jea.client;

import com.mojang.blaze3d.systems.RenderSystem;
import de.melanx.jea.AdvancementInfo;
import de.melanx.jea.client.ClientAdvancementProgress;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.advancements.AdvancementWidgetType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.TooltipFlag;
import org.moddingx.libx.render.RenderHelper;

public class AdvancementDisplayHelper {
    public static void renderAdvancement(GuiGraphics graphics, AdvancementInfo info, AdvancementWidgetType state) {
        graphics.pose().pushPose();
        RenderHelper.resetColor();
        graphics.blitSprite(state.frameSprite(info.getDisplay().getType()), 0, 0, 26, 26);
        graphics.pose().translate(0.0f, 0.0f, 20.0f);
        graphics.renderFakeItem(info.getDisplay().getIcon(), 5, 5);
        RenderHelper.resetColor();
        graphics.renderItemDecorations(Minecraft.getInstance().font, info.getDisplay().getIcon(), 5, 5);
        graphics.pose().popPose();
        RenderSystem.applyModelViewMatrix();
    }

    public static void addAdvancementTooltipToList(AdvancementInfo info, List<Component> list, TooltipFlag flag) {
        list.add(info.getFormattedDisplayName());
        list.add(info.getDisplay().getDescription());
        AdvancementProgress progress = ClientAdvancementProgress.getProgress(info.id);
        if (progress != null && progress.getPercent() >= 1.0f) {
            list.add((Component)info.getDisplay().getType().getDisplayName().copy().withStyle(ChatFormatting.YELLOW));
        } else if (progress != null && progress.getPercent() < 1.0f && progress.getPercent() > 0.0f) {
            list.add((Component)Component.translatable((String)"jea.advancement.partial", (Object[])new Object[]{Mth.clamp((int)Math.round(progress.getPercent() * 100.0f), (int)1, (int)99) + "%"}).withStyle(ChatFormatting.YELLOW));
        } else {
            list.add((Component)Component.translatable((String)"jea.advancement.incomplete").withStyle(ChatFormatting.YELLOW));
        }
        if (flag.isAdvanced()) {
            list.add((Component)Component.literal((String)info.getId().toString()).withStyle(ChatFormatting.DARK_GRAY));
        }
    }
}

