/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.excavar;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.melanx.excavar.ConfigHandler;
import de.melanx.excavar.Excavar;
import de.melanx.excavar.ShapeUtil;
import de.melanx.excavar.api.Excavador;
import de.melanx.excavar.api.PlayerHandler;
import de.melanx.excavar.api.events.DiggingEvent;
import de.melanx.excavar.api.shape.Shapes;
import de.melanx.excavar.client.HiddenRenderTypes;
import de.melanx.excavar.config.ListHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterRenderPipelinesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber(modid="excavar")
public class EventListener {
    public static Map<UUID, List<ItemEntity>> ITEMS_FOR_PLAYER = Maps.newHashMap();

    @SubscribeEvent
    public static void onBreakBlock(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PlayerHandler playerHandler = Excavar.getPlayerHandler();
            UUID playerId = player2.getGameProfile().id();
            if (playerHandler.canDig((Player)player2)) {
                BlockState state = event.getState();
                if (!ShapeUtil.miningAllowed(state) || !ListHandler.isToolAllowed(player2.getMainHandItem())) {
                    return;
                }
                ServerLevel level = player2.level();
                if (((DiggingEvent.Pre)NeoForge.EVENT_BUS.post((Event)new DiggingEvent.Pre(level, player2, Lists.newArrayList(), state.getBlock()))).isCanceled()) {
                    return;
                }
                Direction side = ((BlockHitResult)player2.pick(20.0, 0.0f, false)).getDirection();
                ResourceLocation shapeId = playerHandler.getShapeId(playerId);
                if (!((Boolean)ConfigHandler.allowShapeSelection.get()).booleanValue() || Shapes.SHAPELESS.equals((Object)shapeId)) {
                    shapeId = ShapeUtil.getShapeId(state.getBlock());
                }
                Excavador excavador = new Excavador(shapeId, event.getPos(), (Level)level, (Player)player2, side, state);
                excavador.findBlocks();
                if (((DiggingEvent.FoundPositions)NeoForge.EVENT_BUS.post((Event)new DiggingEvent.FoundPositions(level, player2, excavador.getBlocksToMine(), state.getBlock()))).isCanceled()) {
                    playerHandler.stopDigging(playerId);
                    return;
                }
                playerHandler.startDigging(playerId);
                excavador.mine(event.getPlayer().getMainHandItem());
                playerHandler.stopDigging(playerId);
                if (ITEMS_FOR_PLAYER.containsKey(playerId)) {
                    ITEMS_FOR_PLAYER.get(playerId).forEach(e -> {
                        e.setPos((double)event.getPos().getX(), (double)event.getPos().getY(), (double)event.getPos().getZ());
                        level.addFreshEntity((Entity)e);
                    });
                    ITEMS_FOR_PLAYER.remove(playerId);
                }
                NeoForge.EVENT_BUS.post((Event)new DiggingEvent.Post(level, player2, excavador.getBlocksToMine(), state.getBlock()));
            }
        }
    }

    @SubscribeEvent
    public static void captureDrops(BlockDropsEvent event) {
        if (!((Boolean)ConfigHandler.collectDrops.get()).booleanValue()) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        Entity entity = event.getBreaker();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (Excavar.getPlayerHandler().isDigging(player.getGameProfile().id())) {
                event.setCanceled(true);
                ITEMS_FOR_PLAYER.computeIfAbsent(player.getGameProfile().id(), id -> new ArrayList()).addAll(event.getDrops());
            }
        }
    }

    @SubscribeEvent
    public static void register(RegisterRenderPipelinesEvent event) {
        event.registerPipeline(HiddenRenderTypes.HIDDEN_RENDER_PIPELINE);
    }
}

