/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.excavar.api.shape;

import de.melanx.excavar.api.ConfiguredSameTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockState;

public interface Matcher {
    public static final Matcher SAME_BLOCK = (original, state) -> original.getBlock() == state.getBlock() || ConfiguredSameTags.isAllowed(original, state);
    public static final Matcher PLANT = (original, state) -> {
        VegetationBlock veggi;
        Block patt0$temp = state.getBlock();
        return patt0$temp instanceof VegetationBlock && Matcher.plantType((Block)(veggi = (VegetationBlock)patt0$temp)) == Matcher.plantType(original.getBlock());
    };

    public boolean test(BlockState var1, BlockState var2);

    private static PlantType plantType(Block block) {
        if (block instanceof CropBlock) {
            return PlantType.CROP;
        }
        if (block instanceof SaplingBlock) {
            return PlantType.SAPLING;
        }
        if (block instanceof FlowerBlock) {
            return PlantType.FLOWER;
        }
        return PlantType.GRASS;
    }

    public static enum PlantType {
        CROP,
        SAPLING,
        FLOWER,
        GRASS;

    }
}

