/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.excavar.client;

import de.melanx.excavar.ConfigHandler;
import de.melanx.excavar.Excavar;
import de.melanx.excavar.api.PlayerHandler;
import de.melanx.excavar.api.shape.Shapes;
import de.melanx.excavar.client.BlockRenderer;
import de.melanx.excavar.client.ClientConfig;
import de.melanx.excavar.network.DiggingNetwork;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.client.CustomBlockOutlineRenderer;
import net.neoforged.neoforge.client.event.ExtractBlockOutlineRenderStateEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="excavar", dist={Dist.CLIENT})
public class ClientExcavar {
    public static final KeyMapping.Category EXCAVAR_KEYS = new KeyMapping.Category(ResourceLocation.fromNamespaceAndPath((String)"excavar", (String)"keys"));
    public static final KeyMapping EXCAVAR = new KeyMapping("excavar.key.excavar", 342, EXCAVAR_KEYS);

    public ClientExcavar(IEventBus bus, ModContainer modContainer) {
        NeoForge.EVENT_BUS.register((Object)this);
        bus.addListener(this::onRegisterKeys);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.CLIENT_CONFIG);
    }

    public void onRegisterKeys(RegisterKeyMappingsEvent event) {
        event.registerCategory(EXCAVAR_KEYS);
        event.register(EXCAVAR);
    }

    @SubscribeEvent
    public void keyInput(InputEvent.Key event) {
        if (event.getKey() == EXCAVAR.getKey().getValue()) {
            ClientExcavar.handleInput(event.getAction());
        }
        if (EXCAVAR.isDown() && Minecraft.getInstance().hasShiftDown() && Minecraft.getInstance().player != null) {
            ClientExcavar.displayShapeSelection((Player)Minecraft.getInstance().player);
        }
    }

    @SubscribeEvent
    public void mouseInput(InputEvent.MouseButton.Pre event) {
        if (event.getButton() == EXCAVAR.getKey().getValue()) {
            ClientExcavar.handleInput(event.getAction());
        }
    }

    @SubscribeEvent
    public void mouseScroll(InputEvent.MouseScrollingEvent event) {
        ResourceLocation id;
        ResourceLocation prevId;
        if (!((Boolean)ConfigHandler.allowShapeSelection.get()).booleanValue()) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (EXCAVAR.isDown() && Minecraft.getInstance().hasShiftDown() && player != null && Minecraft.getInstance().screen == null && (prevId = Shapes.getSelectedShape()) != (id = event.getScrollDeltaY() > 0.0 ? Shapes.previousShapeId() : Shapes.nextShapeId())) {
            PlayerHandler.ClientData data = new PlayerHandler.ClientData((Boolean)ClientConfig.onlyWhileSneaking.get(), (Boolean)ClientConfig.preventToolsBreaking.get(), id);
            DiggingNetwork.update((Player)player, data);
            Excavar.getPlayerHandler().putPlayer(player.getGameProfile().id(), data);
            ClientExcavar.displayShapeSelection((Player)player);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void renderBlockHighlights(ExtractBlockOutlineRenderStateEvent event) {
        event.addCustomRenderer((CustomBlockOutlineRenderer)new BlockRenderer());
    }

    private static void handleInput(int action) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (action == 1) {
            PlayerHandler.ClientData data = new PlayerHandler.ClientData((Boolean)ClientConfig.onlyWhileSneaking.get(), (Boolean)ClientConfig.preventToolsBreaking.get(), Shapes.getSelectedShape());
            DiggingNetwork.press((Player)player, data);
            Excavar.getPlayerHandler().putPlayer(player.getGameProfile().id(), data);
        } else if (action == 0) {
            DiggingNetwork.release((Player)player);
            Excavar.getPlayerHandler().removePlayer(player.getGameProfile().id());
        }
    }

    private static void displayShapeSelection(Player player) {
        ResourceLocation id = Shapes.getSelectedShape();
        MutableComponent msg = Component.translatable((String)"excavar.shape.selected");
        msg.append((Component)Component.translatable((String)(id.getNamespace() + ".shape." + id.getPath().replace("/", ".") + ".desc")).withStyle(ChatFormatting.GOLD));
        player.displayClientMessage((Component)msg, true);
    }
}

