/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.excavar.impl.shape;

import com.google.common.collect.Lists;
import de.melanx.excavar.api.shape.Shape;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class Shapeless
implements Shape {
    private static final Iterable<Direction> DIRECTIONS = List.of(Direction.values());
    private static final List<BlockPos> CORNER_OFFSETS = Lists.newArrayList((Object[])new BlockPos[]{new BlockPos(0, -1, -1), new BlockPos(0, -1, 1), new BlockPos(0, 1, -1), new BlockPos(0, 1, 1), new BlockPos(-1, 0, -1), new BlockPos(-1, 0, 1), new BlockPos(-1, -1, 0), new BlockPos(-1, -1, -1), new BlockPos(-1, -1, 1), new BlockPos(-1, 1, 0), new BlockPos(-1, 1, -1), new BlockPos(-1, 1, 1), new BlockPos(1, 0, -1), new BlockPos(1, 0, 1), new BlockPos(1, -1, 0), new BlockPos(1, -1, -1), new BlockPos(1, -1, 1), new BlockPos(1, 1, 0), new BlockPos(1, 1, -1), new BlockPos(1, 1, 1)});

    @Override
    public void addNeighbors(Level level, Player player, BlockPos.MutableBlockPos pos, Direction forwardDirection, BlockState originalState, List<BlockPos> blocksToMine, int maxBlocks) {
        BlockPos mainPos = pos.immutable();
        this.addNeighbors(level, player, pos, originalState, blocksToMine, maxBlocks, mainPos);
    }

    protected Iterable<Direction> directions() {
        return DIRECTIONS;
    }

    protected List<BlockPos> cornerOffsets() {
        return CORNER_OFFSETS;
    }

    protected void addNeighbors(Level level, Player player, BlockPos.MutableBlockPos pos, BlockState originalState, List<BlockPos> blocksToMine, int maxBlocks, BlockPos mainPos) {
        if (maxBlocks <= 0) {
            return;
        }
        HashSet<BlockPos> usedBlocks = new HashSet<BlockPos>();
        while (maxBlocks > 0 && mainPos != null) {
            pos.set((Vec3i)mainPos);
            usedBlocks.add(mainPos);
            maxBlocks = this.tryAddByDirections(level, player, pos, mainPos, originalState, blocksToMine, maxBlocks);
            maxBlocks = this.tryAddByOffsets(level, player, pos, mainPos, originalState, blocksToMine, maxBlocks);
            mainPos = blocksToMine.stream().filter(p -> !usedBlocks.contains(p)).findFirst().orElse(null);
        }
    }

    protected int tryAddBlock(Level level, Player player, BlockPos.MutableBlockPos pos, BlockPos originalPos, BlockState originalState, List<BlockPos> blocksToMine, int maxBlocks) {
        if (this.canAddBlock(level, player, (BlockPos)pos, originalState, blocksToMine, maxBlocks)) {
            blocksToMine.add(pos.immutable());
            --maxBlocks;
        }
        pos.set((Vec3i)originalPos);
        return maxBlocks;
    }

    protected int tryAddByDirections(Level level, Player player, BlockPos.MutableBlockPos pos, BlockPos originalPos, BlockState originalState, List<BlockPos> blocksToMine, int maxBlocks) {
        for (Direction direction : this.directions()) {
            pos.move(direction);
            maxBlocks = this.tryAddBlock(level, player, pos, originalPos, originalState, blocksToMine, maxBlocks);
        }
        return maxBlocks;
    }

    protected int tryAddByOffsets(Level level, Player player, BlockPos.MutableBlockPos pos, BlockPos originalPos, BlockState originalState, List<BlockPos> blocksToMine, int maxBlocks) {
        for (BlockPos offset : this.cornerOffsets()) {
            pos.move((Vec3i)offset);
            maxBlocks = this.tryAddBlock(level, player, pos, originalPos, originalState, blocksToMine, maxBlocks);
        }
        return maxBlocks;
    }
}

