/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.excavar.client;

import de.melanx.excavar.ConfigHandler;
import de.melanx.excavar.Excavar;
import de.melanx.excavar.ShapeUtil;
import de.melanx.excavar.api.PlayerHandler;
import de.melanx.excavar.api.shape.Shape;
import de.melanx.excavar.api.shape.Shapes;
import de.melanx.excavar.client.BlockHighlighter;
import de.melanx.excavar.client.ClientConfig;
import de.melanx.excavar.config.ListHandler;
import de.melanx.excavar.network.DiggingNetwork;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="excavar", dist={Dist.CLIENT})
public class ClientExcavar {
    public static final KeyMapping EXCAVAR = new KeyMapping("excavar.key.excavar", 342, "Excavar");
    private BlockHighlighter blockHighlighter = null;
    private Matcher matcher = new Matcher(BlockPos.ZERO, null, Blocks.AIR.defaultBlockState(), null, null);

    public ClientExcavar(IEventBus bus, ModContainer modContainer) {
        NeoForge.EVENT_BUS.register((Object)this);
        bus.addListener(this::onRegisterKeys);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.CLIENT_CONFIG);
        modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    public void onRegisterKeys(RegisterKeyMappingsEvent event) {
        event.register(EXCAVAR);
    }

    @SubscribeEvent
    public void keyInput(InputEvent.Key event) {
        if (event.getKey() == EXCAVAR.getKey().getValue()) {
            ClientExcavar.handleInput(event.getAction());
        }
        if (EXCAVAR.isDown() && Screen.hasShiftDown() && Minecraft.getInstance().player != null) {
            ClientExcavar.displayShapeSelection((Player)Minecraft.getInstance().player);
        }
    }

    @SubscribeEvent
    public void mouseInput(InputEvent.MouseButton.Pre event) {
        if (event.getButton() == EXCAVAR.getKey().getValue()) {
            ClientExcavar.handleInput(event.getAction());
        }
    }

    @SubscribeEvent
    public void mouseScroll(InputEvent.MouseScrollingEvent event) {
        ResourceLocation id;
        ResourceLocation prevId;
        if (!((Boolean)ConfigHandler.allowShapeSelection.get()).booleanValue()) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (EXCAVAR.isDown() && Screen.hasShiftDown() && player != null && Minecraft.getInstance().screen == null && (prevId = Shapes.getSelectedShape()) != (id = event.getScrollDeltaY() > 0.0 ? Shapes.previousShapeId() : Shapes.nextShapeId())) {
            PlayerHandler.ClientData data = new PlayerHandler.ClientData((Boolean)ClientConfig.onlyWhileSneaking.get(), (Boolean)ClientConfig.preventToolsBreaking.get(), id);
            DiggingNetwork.update((Player)player, data);
            Excavar.getPlayerHandler().putPlayer(player.getGameProfile().getId(), data);
            ClientExcavar.displayShapeSelection((Player)player);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void renderBlockHighlights(RenderHighlightEvent.Block event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (!((Boolean)ClientConfig.enableOutline.get()).booleanValue()) {
            return;
        }
        BlockHitResult hitResult = event.getTarget();
        BlockState state = player.level().getBlockState(hitResult.getBlockPos());
        if (state.isAir() || !ShapeUtil.miningAllowed(state)) {
            return;
        }
        if (EXCAVAR.isDown() && (player.isShiftKeyDown() || !((Boolean)ClientConfig.onlyWhileSneaking.get()).booleanValue()) && ListHandler.isToolAllowed(player.getMainHandItem())) {
            if (!this.matcher.matches(hitResult.getBlockPos(), hitResult.getDirection(), state, player.getMainHandItem(), Shapes.getShape(Shapes.getSelectedShape())) || this.blockHighlighter == null) {
                this.blockHighlighter = new BlockHighlighter(hitResult);
                this.matcher = new Matcher(hitResult.getBlockPos(), hitResult.getDirection(), state, player.getMainHandItem(), Shapes.getShape(Shapes.getSelectedShape()));
            }
            this.blockHighlighter.render(event.getMultiBufferSource(), event.getPoseStack());
        } else {
            this.blockHighlighter = null;
        }
    }

    private static void handleInput(int action) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (action == 1) {
            PlayerHandler.ClientData data = new PlayerHandler.ClientData((Boolean)ClientConfig.onlyWhileSneaking.get(), (Boolean)ClientConfig.preventToolsBreaking.get(), Shapes.getSelectedShape());
            DiggingNetwork.press((Player)player, data);
            Excavar.getPlayerHandler().putPlayer(player.getGameProfile().getId(), data);
        } else if (action == 0) {
            DiggingNetwork.release((Player)player);
            Excavar.getPlayerHandler().removePlayer(player.getGameProfile().getId());
        }
    }

    private static void displayShapeSelection(Player player) {
        ResourceLocation id = Shapes.getSelectedShape();
        MutableComponent msg = Component.translatable((String)"excavar.shape.selected");
        msg.append((Component)Component.translatable((String)(id.getNamespace() + ".shape." + id.getPath().replace("/", ".") + ".desc")).withStyle(ChatFormatting.GOLD));
        player.displayClientMessage((Component)msg, true);
    }

    private record Matcher(@Nonnull BlockPos pos, Direction side, @Nonnull BlockState state, ItemStack tool, Shape shape) {
        public boolean matches(BlockPos otherPos, Direction otherSide, BlockState state, ItemStack tool, Shape shape) {
            return this.pos.equals((Object)otherPos) && this.side == otherSide && this.state.equals((Object)state) && this.tool == tool && this.shape == shape;
        }
    }
}

