/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.excavar.impl.shape;

import de.melanx.excavar.api.shape.Shape;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class BigTunnel
implements Shape {
    @Override
    public void addNeighbors(Level level, Player player, BlockPos.MutableBlockPos pos, Direction forwardDirection, BlockState originalState, List<BlockPos> blocksToMine, int maxBlocks) {
        Direction[] planeAxes = this.crossSectionAxes(forwardDirection);
        Direction axisA = planeAxes[0];
        Direction axisB = planeAxes[1];
        if (this.canAddBlock(level, player, (BlockPos)pos, originalState, blocksToMine, maxBlocks)) {
            blocksToMine.add(pos.immutable());
            --maxBlocks;
        }
        while (maxBlocks > 0) {
            ArrayList<BlockPos> layer = new ArrayList<BlockPos>();
            for (int a = -1; a <= 1; ++a) {
                for (int b = -1; b <= 1; ++b) {
                    BlockPos candidate;
                    if (a == 0 && b == 0 || !this.canAddBlock(level, player, candidate = pos.relative(axisA, a).relative(axisB, b), originalState, blocksToMine, maxBlocks)) continue;
                    layer.add(candidate);
                }
            }
            if (this.canAddBlock(level, player, (BlockPos)(pos = pos.move(forwardDirection)), originalState, blocksToMine, maxBlocks)) {
                layer.add(pos.immutable());
            }
            if (layer.isEmpty()) break;
            int canAdd = Math.min(maxBlocks, layer.size());
            blocksToMine.addAll(layer.subList(0, canAdd));
            maxBlocks -= canAdd;
        }
    }

    private Direction[] crossSectionAxes(Direction forward) {
        Direction[] directionArray;
        switch (forward) {
            default: {
                throw new MatchException(null, null);
            }
            case UP: 
            case DOWN: {
                Direction[] directionArray2 = new Direction[2];
                directionArray2[0] = Direction.EAST;
                directionArray = directionArray2;
                directionArray2[1] = Direction.SOUTH;
                break;
            }
            case NORTH: 
            case SOUTH: {
                Direction[] directionArray3 = new Direction[2];
                directionArray3[0] = Direction.EAST;
                directionArray = directionArray3;
                directionArray3[1] = Direction.UP;
                break;
            }
            case EAST: 
            case WEST: {
                Direction[] directionArray4 = new Direction[2];
                directionArray4[0] = Direction.SOUTH;
                directionArray = directionArray4;
                directionArray4[1] = Direction.UP;
            }
        }
        return directionArray;
    }
}

