/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.excavar.config;

import de.melanx.excavar.ConfigHandler;
import de.melanx.excavar.api.ConfiguredSameTags;
import de.melanx.excavar.api.shape.Shapes;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;

public class ListHandler {
    private static Pattern FORBIDDEN_TOOLS = null;

    private static void validate() {
        if (FORBIDDEN_TOOLS != null) {
            return;
        }
        if (((List)ConfigHandler.deniedTools.get()).isEmpty()) {
            FORBIDDEN_TOOLS = Pattern.compile("(?!)");
            return;
        }
        String regex = ((List)ConfigHandler.deniedTools.get()).stream().map(s -> s.replace("*", ".*")).collect(Collectors.joining("|", "^(", ")$"));
        FORBIDDEN_TOOLS = Pattern.compile(regex);
    }

    public static void onConfigChange(ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (event instanceof ModConfigEvent.Unloading) {
            return;
        }
        if (config.getModId().equals("excavar") && config.getType() == ModConfig.Type.SERVER) {
            FORBIDDEN_TOOLS = null;
            Shapes.refreshSelectableShapes();
            ConfiguredSameTags.refreshTags((List)ConfigHandler.groupedTags.get());
        }
    }

    public static boolean isToolAllowed(ItemStack stack) {
        return ListHandler.isToolAllowed(stack.getItem());
    }

    public static boolean isToolAllowed(Item item) {
        ListHandler.validate();
        return !FORBIDDEN_TOOLS.matcher(BuiltInRegistries.ITEM.getKey((Object)item).toString()).matches();
    }
}

