/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.excavar.api.shape;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.melanx.excavar.ConfigHandler;
import de.melanx.excavar.api.shape.Shape;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.Identifier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Shapes {
    public static final Logger LOGGER = LogManager.getLogger(Shapes.class);
    private static final List<Identifier> allSelectableShapes = Lists.newArrayList();
    private static final List<Identifier> selectableShapes = Lists.newArrayList();
    private static final Map<Identifier, Shape> registry = Maps.newHashMap();
    public static final Identifier SHAPELESS = Identifier.fromNamespaceAndPath((String)"excavar", (String)"shapeless");
    public static final Identifier EASY_SHAPELESS = Identifier.fromNamespaceAndPath((String)"excavar", (String)"easy_shapeless");
    public static final Identifier PLANTS_SHAPELESS = Identifier.fromNamespaceAndPath((String)"excavar", (String)"plants_shapeless");
    public static final Identifier TUNNEL = Identifier.fromNamespaceAndPath((String)"excavar", (String)"tunnel");
    public static final Identifier BIG_TUNNEL = Identifier.fromNamespaceAndPath((String)"excavar", (String)"big_tunnel");
    private static Identifier currentShape = SHAPELESS;

    private Shapes() {
    }

    public static void register(Identifier id, Shape shape) {
        Shapes.register(id, shape, true);
    }

    public static void register(Identifier id, Shape shape, boolean selectable) {
        if (registry.containsKey(id)) {
            throw new IllegalStateException("Shape '" + String.valueOf(id) + "' already registered.");
        }
        registry.put(id, shape);
        LOGGER.info("Registered shape '{}' - selectable {}", (Object)id, (Object)(selectable ? "\u2705" : "\u274c"));
        if (selectable) {
            allSelectableShapes.add(id);
        }
    }

    public static Shape getShape(Identifier id) {
        if (!registry.containsKey(id)) {
            throw new IllegalArgumentException("Shape '" + String.valueOf(id) + "' was not registered.");
        }
        return registry.get(id);
    }

    public static Identifier nextShapeId() {
        int i = selectableShapes.indexOf(currentShape);
        i = i >= selectableShapes.size() - 1 ? 0 : ++i;
        currentShape = selectableShapes.get(i);
        return currentShape;
    }

    public static Identifier previousShapeId() {
        int i = selectableShapes.indexOf(currentShape);
        i = i == 0 ? selectableShapes.size() - 1 : --i;
        currentShape = selectableShapes.get(i);
        return currentShape;
    }

    public static Identifier getSelectedShape() {
        return currentShape;
    }

    public static void refreshSelectableShapes() {
        selectableShapes.clear();
        selectableShapes.addAll(allSelectableShapes);
        selectableShapes.removeIf(id -> ((List)ConfigHandler.deniedShapes.get()).contains(id.toString()));
        currentShape = selectableShapes.contains(currentShape) ? currentShape : selectableShapes.getFirst();
    }
}

