/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.excavar.client;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.melanx.excavar.ShapeUtil;
import de.melanx.excavar.api.Excavador;
import de.melanx.excavar.api.shape.Shapes;
import de.melanx.excavar.client.ClientConfig;
import de.melanx.excavar.client.HiddenRenderTypes;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShapeRenderer;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockHighlighter {
    public static final Color LIGHT_GRAY = new Color(255, 255, 255, 30);
    private final Excavador excavador;
    private VoxelShape shape;
    private final ClientLevel level;

    public BlockHighlighter(Excavador excavador) {
        this.excavador = excavador;
        this.level = Minecraft.getInstance().level;
    }

    public BlockHighlighter(BlockHitResult hitResult) {
        this.level = Minecraft.getInstance().level;
        LocalPlayer player = Minecraft.getInstance().player;
        BlockState state = this.level.getBlockState(hitResult.getBlockPos());
        Identifier shapeId = Shapes.getSelectedShape();
        if (shapeId == Shapes.SHAPELESS) {
            shapeId = ShapeUtil.getShapeId(state.getBlock());
        }
        this.excavador = new Excavador(shapeId, hitResult.getBlockPos(), (Level)this.level, (Player)player, hitResult.getDirection(), state);
    }

    private VoxelShape shape() {
        if (this.shape == null) {
            ItemStack heldItem = Minecraft.getInstance().player.getMainHandItem();
            int maxBlocks = (Boolean)ClientConfig.considerDurability.get() != false && heldItem.isDamageableItem() ? heldItem.getMaxDamage() - heldItem.getDamageValue() - ((Boolean)ClientConfig.preventToolsBreaking.get() != false ? 2 : 1) : Integer.MAX_VALUE;
            this.excavador.findBlocks(maxBlocks);
            ArrayList allShapes = Lists.newArrayList();
            for (BlockPos pos : this.excavador.getBlocksToMine()) {
                VoxelShape blockShape = this.excavador.level.getBlockState(pos).getShape((BlockGetter)this.excavador.level, pos, CollisionContext.empty());
                double dx = pos.getX() - this.excavador.start.getX();
                double dy = pos.getY() - this.excavador.start.getY();
                double dz = pos.getZ() - this.excavador.start.getZ();
                allShapes.add(blockShape.move(dx, dy, dz));
            }
            this.shape = net.minecraft.world.phys.shapes.Shapes.or((VoxelShape)net.minecraft.world.phys.shapes.Shapes.empty(), (VoxelShape[])allShapes.toArray(new VoxelShape[0])).optimize();
        }
        return this.shape;
    }

    public void render(MultiBufferSource buffer, PoseStack poseStack) {
        poseStack.pushPose();
        Vec3 projection = Minecraft.getInstance().gameRenderer.getMainCamera().position();
        poseStack.translate((double)this.excavador.start.getX() - projection.x, (double)this.excavador.start.getY() - projection.y, (double)this.excavador.start.getZ() - projection.z);
        VoxelShape allBlocksShape = this.shape();
        ShapeRenderer.renderShape((PoseStack)poseStack, (VertexConsumer)buffer.getBuffer(RenderTypes.LINES), (VoxelShape)allBlocksShape, (double)0.0, (double)0.0, (double)0.0, (int)Color.WHITE.getRGB(), (float)2.0f);
        ShapeRenderer.renderShape((PoseStack)poseStack, (VertexConsumer)buffer.getBuffer(HiddenRenderTypes.HIDDEN_OUTLINES), (VoxelShape)allBlocksShape, (double)0.0, (double)0.0, (double)0.0, (int)LIGHT_GRAY.getRGB(), (float)2.0f);
        poseStack.popPose();
    }
}

