/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.excavar.api;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.melanx.excavar.api.shape.Shapes;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.player.Player;

public class PlayerHandler {
    private final Map<UUID, ClientData> players = Maps.newHashMap();
    private final Set<UUID> diggers = Sets.newHashSet();

    public void startDigging(UUID id) {
        this.diggers.add(id);
    }

    public void stopDigging(UUID id) {
        this.diggers.remove(id);
    }

    public boolean isDigging(UUID id) {
        return this.diggers.contains(id);
    }

    public boolean canDig(Player player) {
        UUID id = player.getGameProfile().id();
        return this.players.containsKey(id) && (!this.players.get((Object)id).requiresSneaking || player.isShiftKeyDown()) && !this.isDigging(id);
    }

    public Identifier getShapeId(UUID id) {
        ClientData data = this.players.get(id);
        return data == null ? Shapes.getSelectedShape() : data.shapeId();
    }

    @Deprecated(forRemoval=true)
    public void addPlayer(UUID id, ClientData data) {
        this.putPlayer(id, data);
    }

    public void putPlayer(UUID id, ClientData data) {
        this.players.put(id, data);
    }

    public void removePlayer(UUID id) {
        this.players.remove(id);
    }

    @Nonnull
    public ClientData getData(UUID id) {
        return this.players.getOrDefault(id, ClientData.EMPTY);
    }

    public record ClientData(boolean requiresSneaking, boolean preventToolBreaking, Identifier shapeId) {
        private static final Identifier MISSINGNO = Identifier.fromNamespaceAndPath((String)"minecraft", (String)"missingno");
        public static final ClientData EMPTY = new ClientData(false, false, MISSINGNO);
    }
}

