/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.excavar.api;

import com.google.common.collect.Lists;
import de.melanx.excavar.ConfigHandler;
import de.melanx.excavar.Excavar;
import de.melanx.excavar.api.shape.Shape;
import de.melanx.excavar.api.shape.Shapes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.EventHooks;

public class Excavador {
    public static final TagKey<Block> FORBIDDEN_BLOCKS = TagKey.create((ResourceKey)Registries.BLOCK, (Identifier)Identifier.fromNamespaceAndPath((String)"excavar", (String)"forbidden_blocks"));
    public final BlockPos start;
    public final Level level;
    public final Player player;
    public final Direction side;
    private final BlockState originalState;
    private final List<BlockPos> blocksToMine = Lists.newArrayList();
    private final boolean preventToolBreaking;
    private final boolean requiresCorrectTool;
    private final Shape shape;

    public Excavador(@Nonnull BlockPos start, @Nonnull Level level, @Nonnull Player player, @Nonnull Direction side, @Nonnull BlockState originalState) {
        this(start, level, player, side, originalState, (Boolean)ConfigHandler.requiresCorrectTool.get());
    }

    public Excavador(@Nonnull BlockPos start, @Nonnull Level level, @Nonnull Player player, @Nonnull Direction side, @Nonnull BlockState originalState, boolean requiresCorrectTool) {
        this(Shapes.getSelectedShape(), start, level, player, side, originalState, requiresCorrectTool, Excavar.getPlayerHandler().getData(player.getGameProfile().id()).preventToolBreaking());
    }

    public Excavador(@Nonnull Identifier shapeId, @Nonnull BlockPos start, @Nonnull Level level, @Nonnull Player player, @Nonnull Direction side, @Nonnull BlockState originalState) {
        this(shapeId, start, level, player, side, originalState, (Boolean)ConfigHandler.requiresCorrectTool.get());
    }

    public Excavador(@Nonnull Identifier shapeId, @Nonnull BlockPos start, @Nonnull Level level, @Nonnull Player player, @Nonnull Direction side, @Nonnull BlockState originalState, boolean requiresCorrectTool) {
        this(shapeId, start, level, player, side, originalState, requiresCorrectTool, Excavar.getPlayerHandler().getData(player.getGameProfile().id()).preventToolBreaking());
    }

    public Excavador(@Nonnull Identifier shapeId, @Nonnull BlockPos start, @Nonnull Level level, @Nonnull Player player, @Nonnull Direction side, @Nonnull BlockState originalState, boolean requiresCorrectTool, boolean preventToolBreaking) {
        this.start = start.immutable();
        this.level = level;
        this.player = player;
        this.side = side;
        this.originalState = originalState;
        this.preventToolBreaking = preventToolBreaking;
        this.requiresCorrectTool = requiresCorrectTool;
        this.shape = Shapes.getShape(shapeId);
    }

    public void findBlocks() {
        this.findBlocks(Integer.MAX_VALUE);
    }

    public void findBlocks(int maxBlocks) {
        if (!this.blocksToMine.isEmpty()) {
            return;
        }
        int limit = Math.min(maxBlocks, (Integer)ConfigHandler.blockLimit.get());
        this.blocksToMine.add(this.start);
        --limit;
        if (this.cannotMine()) {
            return;
        }
        if (((Boolean)ConfigHandler.invertForbiddenTag.get()).booleanValue() != this.level.getBlockState(this.start).is(FORBIDDEN_BLOCKS)) {
            return;
        }
        ArrayList<BlockPos> collectedBlocks = new ArrayList<BlockPos>(this.blocksToMine);
        this.shape.addNeighbors(this.level, this.player, this.start.mutable(), this.side.getOpposite(), this.originalState, collectedBlocks, limit);
        collectedBlocks.remove(this.start);
        int canAdd = Math.min(limit, collectedBlocks.size());
        this.blocksToMine.addAll(collectedBlocks.subList(0, canAdd));
    }

    public void mine(ItemStack tool) {
        int totalPlayerXp = Excavador.getExpPoints(this.player.experienceLevel, this.player.experienceProgress);
        int stopAt = this.preventToolBreaking ? 2 : 1;
        Player player = this.player;
        if (!(player instanceof ServerPlayer)) {
            throw new IllegalStateException("Can't mine on client side");
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        int i = 0;
        boolean payedXp = false;
        for (BlockPos pos : this.blocksToMine) {
            boolean tooLessXp;
            boolean xpUsageRequirement = switch ((ConfigHandler.XpUsageType)((Object)ConfigHandler.xpUsageType.get())) {
                default -> throw new MatchException(null, null);
                case ConfigHandler.XpUsageType.PER_BLOCK -> {
                    if (i >= 1) {
                        yield true;
                    }
                    yield false;
                }
                case ConfigHandler.XpUsageType.PER_ACTION -> i == 1 || !payedXp;
            };
            boolean bl = tooLessXp = xpUsageRequirement && totalPlayerXp - (Integer)ConfigHandler.xpUsage.get() < 0;
            if ((tool.isDamageableItem() && tool.getMaxDamage() - tool.getDamageValue() <= stopAt || tooLessXp) && !serverPlayer.isCreative()) {
                if (!tooLessXp) break;
                serverPlayer.sendSystemMessage((Component)Component.translatable((String)"excavar.config.xp_usage.missing", (Object[])new Object[]{this.blocksToMine.size() - i - (Integer)ConfigHandler.xpUsage.get()}));
                break;
            }
            if (serverPlayer.gameMode.destroyBlock(pos)) {
                serverPlayer.causeFoodExhaustion((float)((Double)ConfigHandler.hungerUsage.get() - (double)0.005f));
                if (xpUsageRequirement) {
                    payedXp = true;
                    serverPlayer.giveExperiencePoints(-((Integer)ConfigHandler.xpUsage.get()).intValue());
                    totalPlayerXp -= ((Integer)ConfigHandler.xpUsage.get()).intValue();
                }
            }
            ++i;
        }
    }

    public List<BlockPos> getBlocksToMine() {
        return this.blocksToMine;
    }

    private boolean cannotMine() {
        boolean forbiddenFist;
        BlockState state = this.level.getBlockState(this.start);
        boolean bl = forbiddenFist = (Boolean)ConfigHandler.fistForbidden.get() != false && this.player.getMainHandItem().isEmpty() && state.getDestroySpeed((BlockGetter)this.level, this.start) > 0.0f;
        if (!this.requiresCorrectTool) {
            return forbiddenFist;
        }
        boolean cannotHarvest = !EventHooks.doPlayerHarvestCheck((Player)this.player, (BlockState)state, (BlockGetter)this.level, (BlockPos)this.start);
        ItemStack mainHandItem = this.player.getMainHandItem();
        boolean toolTagMatches = this.toolTagMatchesBlock(mainHandItem, state);
        return !toolTagMatches || cannotHarvest || forbiddenFist;
    }

    private boolean toolTagMatchesBlock(ItemStack stack, BlockState state) {
        boolean blockNeedsSword;
        boolean isAxe = stack.is(ItemTags.AXES);
        boolean isHoe = stack.is(ItemTags.HOES);
        boolean isPickaxe = stack.is(ItemTags.PICKAXES);
        boolean isShovel = stack.is(ItemTags.SHOVELS);
        boolean isSword = stack.is(ItemTags.SWORDS);
        boolean blockNeedsAxe = state.is(BlockTags.MINEABLE_WITH_AXE);
        boolean blockNeedsHoe = state.is(BlockTags.MINEABLE_WITH_HOE);
        boolean blockNeedsPickaxe = state.is(BlockTags.MINEABLE_WITH_PICKAXE);
        boolean blockNeedsShovel = state.is(BlockTags.MINEABLE_WITH_SHOVEL);
        boolean bl = blockNeedsSword = state.is(BlockTags.SWORD_EFFICIENT) || state.is(BlockTags.SWORD_INSTANTLY_MINES);
        if (isAxe && blockNeedsAxe) {
            return true;
        }
        if (isHoe && blockNeedsHoe) {
            return true;
        }
        if (isPickaxe && blockNeedsPickaxe) {
            return true;
        }
        if (isShovel && blockNeedsShovel) {
            return true;
        }
        if (isSword && blockNeedsSword) {
            return true;
        }
        return !blockNeedsAxe && !blockNeedsHoe && !blockNeedsPickaxe && !blockNeedsShovel && !blockNeedsSword;
    }

    private static int getExpPoints(int level, float exp) {
        int points = 0;
        for (int i = 0; i < level; ++i) {
            points += Excavador.getXpBarCap(i);
        }
        return points += Math.round((float)Excavador.getXpBarCap(level) * exp);
    }

    private static int getXpBarCap(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        if (level < 0) {
            return 0;
        }
        return 7 + level * 2;
    }
}

