/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.excavar.client;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;

public class OutlineRenderType
extends RenderType {
    private static final Map<RenderType, OutlineRenderType> TYPES = new HashMap<RenderType, OutlineRenderType>();
    private final RenderType parent;

    private OutlineRenderType(RenderType parent) {
        super("Outline" + parent.name, parent.format(), parent.mode(), parent.bufferSize(), parent.affectsCrumbling(), parent.sortOnUpload, () -> ((RenderType)parent).setupRenderState(), () -> ((RenderType)parent).clearRenderState());
        this.parent = parent;
    }

    @Nonnull
    public String toString() {
        return "Outline" + this.parent.toString();
    }

    public void setupRenderState() {
        this.parent.setupRenderState();
        if (Minecraft.getInstance().levelRenderer.entityOutlineTarget() != null) {
            Minecraft.getInstance().levelRenderer.entityOutlineTarget().bindWrite(false);
        }
    }

    public void clearRenderState() {
        Minecraft.getInstance().getMainRenderTarget().bindWrite(false);
        this.parent.clearRenderState();
    }

    public static OutlineRenderType get(RenderType parent) {
        if (parent instanceof OutlineRenderType) {
            return (OutlineRenderType)parent;
        }
        if (!TYPES.containsKey(parent)) {
            TYPES.put(parent, new OutlineRenderType(parent));
        }
        return TYPES.get(parent);
    }
}

