/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.excavar;

import com.google.common.collect.Lists;
import de.melanx.excavar.ConfigHandler;
import de.melanx.excavar.Excavar;
import de.melanx.excavar.ShapeUtil;
import de.melanx.excavar.api.Excavador;
import de.melanx.excavar.api.PlayerHandler;
import de.melanx.excavar.api.events.DiggingEvent;
import de.melanx.excavar.api.shape.Shapes;
import de.melanx.excavar.config.ListHandler;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;

public class EventListener {
    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PlayerHandler playerHandler = Excavar.getPlayerHandler();
            UUID playerId = player2.getGameProfile().getId();
            if (playerHandler.canDig((Player)player2)) {
                BlockState state = event.getState();
                if (!ShapeUtil.miningAllowed(state) || !ListHandler.isToolAllowed(player2.getMainHandItem())) {
                    return;
                }
                Level level = player2.level();
                if (((DiggingEvent.Pre)NeoForge.EVENT_BUS.post((Event)new DiggingEvent.Pre((ServerLevel)level, player2, Lists.newArrayList(), state.getBlock()))).isCanceled()) {
                    return;
                }
                Direction side = ((BlockHitResult)player2.pick(20.0, 0.0f, false)).getDirection();
                ResourceLocation shapeId = playerHandler.getShapeId(playerId);
                if (!((Boolean)ConfigHandler.allowShapeSelection.get()).booleanValue() || shapeId == Shapes.SHAPELESS) {
                    shapeId = ShapeUtil.getShapeId(state.getBlock());
                }
                Excavador excavador = new Excavador(shapeId, event.getPos(), level, (Player)player2, side, state);
                excavador.findBlocks();
                if (((DiggingEvent.FoundPositions)NeoForge.EVENT_BUS.post((Event)new DiggingEvent.FoundPositions((ServerLevel)level, player2, excavador.getBlocksToMine(), state.getBlock()))).isCanceled()) {
                    playerHandler.stopDigging(playerId);
                    return;
                }
                playerHandler.startDigging(playerId);
                excavador.mine(event.getPlayer().getMainHandItem());
                playerHandler.stopDigging(playerId);
                NeoForge.EVENT_BUS.post((Event)new DiggingEvent.Post((ServerLevel)level, player2, excavador.getBlocksToMine(), state.getBlock()));
            }
        }
    }
}

