/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.excavar.network.handler;

import de.melanx.excavar.Excavar;
import de.melanx.excavar.api.PlayerHandler;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class KeyPress {
    public static void handle(Message msg, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            if (ctx.getSender() == null) {
                return;
            }
            switch (msg.type) {
                case PRESS: 
                case UPDATE: {
                    Excavar.getPlayerHandler().putPlayer(msg.playerId, msg.data);
                    break;
                }
                case RELEASE: {
                    Excavar.getPlayerHandler().removePlayer(msg.playerId);
                }
            }
        });
        ctx.setPacketHandled(true);
    }

    public record Message(UUID playerId, Type type, PlayerHandler.ClientData data) {
        public Message(UUID playerId, Type type) {
            this(playerId, type, PlayerHandler.ClientData.EMPTY);
        }
    }

    public static enum Type {
        PRESS,
        RELEASE,
        UPDATE;

    }

    public static class Serializer {
        public void encode(Message msg, FriendlyByteBuf buffer) {
            buffer.m_130077_(msg.playerId);
            buffer.m_130068_((Enum)msg.type);
            buffer.writeBoolean(msg.data.requiresSneaking());
            buffer.writeBoolean(msg.data.preventToolBreaking());
            buffer.m_130085_(msg.data.shapeId());
        }

        public Message decode(FriendlyByteBuf buffer) {
            return new Message(buffer.m_130259_(), (Type)buffer.m_130066_(Type.class), new PlayerHandler.ClientData(buffer.readBoolean(), buffer.readBoolean(), buffer.m_130281_()));
        }
    }
}

