/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.excavar.config;

import de.melanx.excavar.ConfigHandler;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class ListHandler {
    private static Pattern FORBIDDEN_TOOLS = null;

    private static void validate() {
        if (FORBIDDEN_TOOLS != null) {
            return;
        }
        if (((List)ConfigHandler.deniedTools.get()).isEmpty()) {
            FORBIDDEN_TOOLS = Pattern.compile("(?!)");
            return;
        }
        String regex = ((List)ConfigHandler.deniedTools.get()).stream().map(s -> s.replace("*", ".*")).collect(Collectors.joining("|", "^(", ")$"));
        FORBIDDEN_TOOLS = Pattern.compile(regex);
    }

    public static void onConfigChange(ModConfigEvent event) {
        if (event.getConfig().getModId().equals("excavar")) {
            FORBIDDEN_TOOLS = null;
        }
    }

    public static boolean isToolAllowed(ItemStack stack) {
        return ListHandler.isToolAllowed(stack.m_41720_());
    }

    public static boolean isToolAllowed(Item item) {
        ListHandler.validate();
        return !FORBIDDEN_TOOLS.matcher(String.valueOf(ForgeRegistries.ITEMS.getKey((Object)item))).matches();
    }
}

