/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.excavar.client;

import de.melanx.excavar.ConfigHandler;
import de.melanx.excavar.Excavar;
import de.melanx.excavar.ShapeUtil;
import de.melanx.excavar.api.PlayerHandler;
import de.melanx.excavar.api.shape.Shape;
import de.melanx.excavar.api.shape.Shapes;
import de.melanx.excavar.client.BlockHighlighter;
import de.melanx.excavar.client.ClientConfig;
import de.melanx.excavar.config.ListHandler;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ClientExcavar {
    public static final KeyMapping EXCAVAR = new KeyMapping("excavar.key.excavar", 342, "Excavar");
    private BlockHighlighter blockHighlighter = null;
    private Matcher matcher = new Matcher(BlockPos.f_121853_, null, Blocks.f_50016_.m_49966_(), null, null);

    public ClientExcavar() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.CLIENT_CONFIG);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onRegisterKeys);
    }

    public void onRegisterKeys(RegisterKeyMappingsEvent event) {
        event.register(EXCAVAR);
    }

    @SubscribeEvent
    public void keyInput(InputEvent.Key event) {
        if (event.getKey() == EXCAVAR.getKey().m_84873_()) {
            ClientExcavar.handleInput(event.getAction());
        }
        if (EXCAVAR.m_90857_() && Screen.m_96638_() && Minecraft.m_91087_().f_91074_ != null) {
            ClientExcavar.displayShapeSelection((Player)Minecraft.m_91087_().f_91074_);
        }
    }

    @SubscribeEvent
    public void mouseInput(InputEvent.MouseButton event) {
        if (event.getButton() == EXCAVAR.getKey().m_84873_()) {
            ClientExcavar.handleInput(event.getAction());
        }
    }

    @SubscribeEvent
    public void mouseScroll(InputEvent.MouseScrollingEvent event) {
        ResourceLocation id;
        ResourceLocation prevId;
        if (!((Boolean)ConfigHandler.allowShapeSelection.get()).booleanValue()) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (EXCAVAR.m_90857_() && Screen.m_96638_() && player != null && Minecraft.m_91087_().f_91080_ == null && (prevId = Shapes.getSelectedShape()) != (id = event.getScrollDelta() > 0.0 ? Shapes.previousShapeId() : Shapes.nextShapeId())) {
            PlayerHandler.ClientData data = new PlayerHandler.ClientData((Boolean)ClientConfig.onlyWhileSneaking.get(), (Boolean)ClientConfig.preventToolsBreaking.get(), id);
            Excavar.getNetwork().update((Player)player, data);
            Excavar.getPlayerHandler().putPlayer(player.m_36316_().getId(), data);
            ClientExcavar.displayShapeSelection((Player)player);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void renderBlockHighlights(RenderHighlightEvent.Block event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (!((Boolean)ClientConfig.enableOutline.get()).booleanValue() || !ListHandler.isToolAllowed(player.m_21205_())) {
            return;
        }
        BlockHitResult hitResult = event.getTarget();
        BlockState state = player.m_9236_().m_8055_(hitResult.m_82425_());
        if (!ShapeUtil.miningAllowed(state)) {
            return;
        }
        if (EXCAVAR.m_90857_() && (player.m_6144_() || !((Boolean)ClientConfig.onlyWhileSneaking.get()).booleanValue())) {
            if (!this.matcher.matches(hitResult.m_82425_(), hitResult.m_82434_(), state, player.m_21205_(), Shapes.getShape(Shapes.getSelectedShape())) || this.blockHighlighter == null) {
                this.blockHighlighter = new BlockHighlighter(hitResult);
                this.matcher = new Matcher(hitResult.m_82425_(), hitResult.m_82434_(), state, player.m_21205_(), Shapes.getShape(Shapes.getSelectedShape()));
            }
            this.blockHighlighter.render(event.getLevelRenderer(), event.getPoseStack());
        } else {
            this.blockHighlighter = null;
        }
    }

    private static void handleInput(int action) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (action == 1) {
            PlayerHandler.ClientData data = new PlayerHandler.ClientData((Boolean)ClientConfig.onlyWhileSneaking.get(), (Boolean)ClientConfig.preventToolsBreaking.get(), Shapes.getSelectedShape());
            Excavar.getNetwork().press((Player)player, data);
            Excavar.getPlayerHandler().putPlayer(player.m_36316_().getId(), data);
        } else if (action == 0) {
            Excavar.getNetwork().release((Player)player);
            Excavar.getPlayerHandler().removePlayer(player.m_36316_().getId());
        }
    }

    private static void displayShapeSelection(Player player) {
        ResourceLocation id = Shapes.getSelectedShape();
        MutableComponent msg = Component.m_237115_((String)"excavar.shape.selected");
        msg.m_7220_((Component)Component.m_237115_((String)(id.m_135827_() + ".shape." + id.m_135815_().replace("/", ".") + ".desc")).m_130940_(ChatFormatting.GOLD));
        player.m_5661_((Component)msg, true);
    }

    private record Matcher(@Nonnull BlockPos pos, Direction side, @Nonnull BlockState state, ItemStack tool, Shape shape) {
        public boolean matches(BlockPos otherPos, Direction otherSide, BlockState state, ItemStack tool, Shape shape) {
            return this.pos.equals((Object)otherPos) && this.side == otherSide && this.state.equals(state) && this.tool == tool && this.shape == shape;
        }
    }
}

