/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.excavar.client;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.melanx.excavar.ShapeUtil;
import de.melanx.excavar.api.Excavador;
import de.melanx.excavar.api.shape.Shapes;
import de.melanx.excavar.client.ClientConfig;
import de.melanx.excavar.client.OutlineBuffer;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockHighlighter {
    private final Excavador excavador;
    private VoxelShape shape;
    private final ClientLevel level;

    public BlockHighlighter(Excavador excavador) {
        this.excavador = excavador;
        this.level = Minecraft.m_91087_().f_91073_;
    }

    public BlockHighlighter(BlockHitResult hitResult) {
        this.level = Minecraft.m_91087_().f_91073_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        BlockState state = this.level.m_8055_(hitResult.m_82425_());
        ResourceLocation shapeId = Shapes.getSelectedShape();
        if (shapeId == Shapes.SHAPELESS) {
            shapeId = ShapeUtil.getShapeId(state.m_60734_());
        }
        this.excavador = new Excavador(shapeId, hitResult.m_82425_(), (Level)this.level, (Player)player, hitResult.m_82434_(), state);
    }

    private VoxelShape shape() {
        if (this.shape == null) {
            ItemStack heldItem = Minecraft.m_91087_().f_91074_.m_21205_();
            int maxBlocks = (Boolean)ClientConfig.considerDurability.get() != false && heldItem.m_41763_() ? heldItem.m_41776_() - heldItem.m_41773_() - ((Boolean)ClientConfig.preventToolsBreaking.get() != false ? 2 : 1) : Integer.MAX_VALUE;
            this.excavador.findBlocks(maxBlocks);
            ArrayList allShapes = Lists.newArrayList();
            for (BlockPos pos : this.excavador.getBlocksToMine()) {
                VoxelShape blockShape = this.excavador.level.m_8055_(pos).m_60771_((BlockGetter)this.excavador.level, pos, CollisionContext.m_82749_());
                double dx = pos.m_123341_() - this.excavador.start.m_123341_();
                double dy = pos.m_123342_() - this.excavador.start.m_123342_();
                double dz = pos.m_123343_() - this.excavador.start.m_123343_();
                allShapes.add(blockShape.m_83216_(dx, dy, dz));
            }
            this.shape = net.minecraft.world.phys.shapes.Shapes.m_83124_((VoxelShape)net.minecraft.world.phys.shapes.Shapes.m_83040_(), (VoxelShape[])allShapes.toArray(new VoxelShape[0])).m_83296_();
        }
        return this.shape;
    }

    public void render(LevelRenderer levelRenderer, PoseStack poseStack) {
        poseStack.m_85836_();
        Vec3 projection = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        poseStack.m_85837_((double)this.excavador.start.m_123341_() - projection.f_82479_, (double)this.excavador.start.m_123342_() - projection.f_82480_, (double)this.excavador.start.m_123343_() - projection.f_82481_);
        VertexConsumer vertex = OutlineBuffer.INSTANCE.m_6299_(RenderType.m_110504_());
        LevelRenderer.m_109782_((PoseStack)poseStack, (VertexConsumer)vertex, (VoxelShape)this.shape(), (double)0.0, (double)0.0, (double)0.0, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }
}

