/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.excavar;

import com.google.common.collect.Lists;
import de.melanx.excavar.ConfigHandler;
import de.melanx.excavar.Excavar;
import de.melanx.excavar.ShapeUtil;
import de.melanx.excavar.api.Excavador;
import de.melanx.excavar.api.PlayerHandler;
import de.melanx.excavar.api.events.DiggingEvent;
import de.melanx.excavar.api.shape.Shapes;
import de.melanx.excavar.config.ListHandler;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventListener {
    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PlayerHandler playerHandler = Excavar.getPlayerHandler();
            UUID playerId = player2.m_36316_().getId();
            if (playerHandler.canDig((Player)player2)) {
                BlockState state = event.getState();
                if (!ShapeUtil.miningAllowed(state) || !ListHandler.isToolAllowed(player2.m_21205_())) {
                    return;
                }
                Level level = player2.m_9236_();
                if (MinecraftForge.EVENT_BUS.post((Event)new DiggingEvent.Pre((ServerLevel)level, player2, Lists.newArrayList(), state.m_60734_()))) {
                    return;
                }
                Direction side = ((BlockHitResult)player2.m_19907_(20.0, 0.0f, false)).m_82434_();
                ResourceLocation shapeId = playerHandler.getShapeId(playerId);
                if (!((Boolean)ConfigHandler.allowShapeSelection.get()).booleanValue() || shapeId == Shapes.SHAPELESS) {
                    shapeId = ShapeUtil.getShapeId(state.m_60734_());
                }
                Excavador excavador = new Excavador(shapeId, event.getPos(), level, (Player)player2, side, state);
                excavador.findBlocks();
                if (MinecraftForge.EVENT_BUS.post((Event)new DiggingEvent.FoundPositions((ServerLevel)level, player2, excavador.getBlocksToMine(), state.m_60734_()))) {
                    playerHandler.stopDigging(playerId);
                    return;
                }
                playerHandler.startDigging(playerId);
                excavador.mine(event.getPlayer().m_21205_());
                playerHandler.stopDigging(playerId);
                MinecraftForge.EVENT_BUS.post((Event)new DiggingEvent.Post((ServerLevel)level, player2, excavador.getBlocksToMine(), state.m_60734_()));
            }
        }
    }
}

