package de.melanx.excavar.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;

import javax.annotation.Nonnull;
import java.util.HashMap;
import java.util.Map;

// Thanks to
// https://github.com/castcrafter/travel_anchors/blob/0668947e17fac6dc5986a0b59c8fbc5b4e52021d/src/main/java/de/castcrafter/travel_anchors/render/OutlineRenderType.java
public class OutlineRenderType extends RenderType {

    private static final Map<RenderType, OutlineRenderType> TYPES = new HashMap<>();

    private final RenderType parent;

    private OutlineRenderType(RenderType parent) {
        super("Outline" + parent.f_110133_, parent.m_110508_(), parent.m_173186_(), parent.m_110507_(), parent.m_110405_(), parent.f_110393_, parent::m_110185_, parent::m_110188_);
        this.parent = parent;
    }

    @Nonnull
    @Override
    public String toString() {
        return "Outline" + this.parent.toString();
    }

    @Override
    public void m_110185_() {
        this.parent.m_110185_();
        if (Minecraft.m_91087_().f_91060_.m_109827_() != null) {
            //noinspection ConstantConditions
            Minecraft.m_91087_().f_91060_.m_109827_().m_83947_(false);
        }
    }

    @Override
    public void m_110188_() {
        Minecraft.m_91087_().m_91385_().m_83947_(false);
        this.parent.m_110188_();
    }

    public static OutlineRenderType get(RenderType parent) {
        if (parent instanceof OutlineRenderType) {
            return (OutlineRenderType) parent;
        } else {
            if (!TYPES.containsKey(parent)) {
                TYPES.put(parent, new OutlineRenderType(parent));
            }
            return TYPES.get(parent);
        }
    }
}
