package de.melanx.excavar.client;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.melanx.excavar.ShapeUtil;
import de.melanx.excavar.api.Excavador;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

import java.util.List;

public class BlockHighlighter {

    private final Excavador excavador;
    private VoxelShape shape;
    private final ClientLevel level;

    public BlockHighlighter(Excavador excavador) {
        this.excavador = excavador;
        this.level = Minecraft.m_91087_().f_91073_;
    }

    public BlockHighlighter(BlockHitResult hitResult) {
        this.level = Minecraft.m_91087_().f_91073_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        //noinspection ConstantConditions
        BlockState state = this.level.m_8055_(hitResult.m_82425_());
        ResourceLocation shapeId = de.melanx.excavar.api.shape.Shapes.getSelectedShape();
        if (shapeId == de.melanx.excavar.api.shape.Shapes.SHAPELESS) {
            shapeId = ShapeUtil.getShapeId(state.m_60734_());
        }
        //noinspection ConstantConditions
        this.excavador = new Excavador(shapeId, hitResult.m_82425_(), this.level, player, hitResult.m_82434_(), state);
    }

    private VoxelShape shape() {
        if (this.shape == null) {
            //noinspection ConstantConditions
            ItemStack heldItem = Minecraft.m_91087_().f_91074_.m_21205_();
            int maxBlocks = (ClientConfig.considerDurability.get() && heldItem.m_41763_()) ? heldItem.m_41776_() - heldItem.m_41773_() - (ClientConfig.preventToolsBreaking.get() ? 2 : 1) // we need to increase this by 1, otherwise it would display 1 block too much
                    : Integer.MAX_VALUE;
            this.excavador.findBlocks(maxBlocks);
            List<VoxelShape> allShapes = Lists.newArrayList();
            for (BlockPos pos : this.excavador.getBlocksToMine()) {
                VoxelShape blockShape = this.excavador.level.m_8055_(pos).m_60771_(this.excavador.level, pos, CollisionContext.m_82749_());
                double dx = pos.m_123341_() - this.excavador.start.m_123341_();
                double dy = pos.m_123342_() - this.excavador.start.m_123342_();
                double dz = pos.m_123343_() - this.excavador.start.m_123343_();
                allShapes.add(blockShape.m_83216_(dx, dy, dz));
            }
            this.shape = Shapes.m_83124_(Shapes.m_83040_(), allShapes.toArray(new VoxelShape[]{})).m_83296_();
        }

        return this.shape;
    }

    public void render(LevelRenderer levelRenderer, PoseStack poseStack) {
        poseStack.m_85836_();
        Vec3 projection = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        poseStack.m_85837_(this.excavador.start.m_123341_() - projection.f_82479_, this.excavador.start.m_123342_() - projection.f_82480_, this.excavador.start.m_123343_() - projection.f_82481_);

        VertexConsumer vertex = OutlineBuffer.INSTANCE.m_6299_(RenderType.m_110504_());
        LevelRenderer.m_109782_(poseStack, vertex, this.shape(), 0, 0, 0, 1, 1, 1, 1);
        poseStack.m_85849_();
    }
}
