package de.melanx.excavar.api.shape;

import net.minecraft.world.level.block.*;
import net.minecraft.world.level.block.state.BlockState;

/**
 * An interface to test if the original and current {@link BlockState} match.
 */
public interface Matcher {

    boolean test(BlockState original, BlockState state);

    Matcher SAME_BLOCK = (original, state) -> original.m_60734_() == state.m_60734_();
    Matcher PLANT = (original, state) -> state.m_60734_() instanceof BushBlock bush && Matcher.plantType(bush) == Matcher.plantType(original.m_60734_());

    private static PlantType plantType(Block block) {
        if (block instanceof CropBlock) {
            return PlantType.CROP;
        } else if (block instanceof SaplingBlock) {
            return PlantType.SAPLING;
        } else if (block instanceof FlowerBlock) {
            return PlantType.FLOWER;
        }

        return PlantType.GRASS;
    }

    enum PlantType {
        CROP,
        SAPLING,
        FLOWER,
        GRASS
    }
}
