/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.defaultworldtype.mixin;

import de.melanx.defaultworldtype.ClientConfig;
import de.melanx.defaultworldtype.DefaultWorldType;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screens.PresetFlatWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.client.gui.screens.worldselection.WorldCreationUiState;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldCreationUiState.class})
public abstract class WorldCreationUiStateMixin {
    @Inject(method={"updatePresetLists"}, at={@At(value="TAIL")})
    private void afterUpdatePresetLists(CallbackInfo ci) {
        WorldCreationUiState state = (WorldCreationUiState)this;
        Registry worldPresets = state.getSettings().worldgenLoadContext().lookupOrThrow(Registries.WORLD_PRESET);
        Registry biomes = state.getSettings().worldgenLoadContext().lookupOrThrow(Registries.BIOME);
        WorldCreationUiStateMixin.defaultWorldType$writeRegistryToFile(worldPresets, "world-presets");
        WorldCreationUiStateMixin.defaultWorldType$writeRegistryToFile(biomes, "biomes");
        List<WorldCreationUiState.WorldTypeEntry> preferredPresets = WorldCreationUiStateMixin.defaultWorldType$buildPreferredPresetEntries((Registry<WorldPreset>)worldPresets);
        if (!preferredPresets.isEmpty()) {
            state.normalPresetList.clear();
            state.normalPresetList.addAll(preferredPresets);
        }
        WorldCreationUiStateMixin.defaultWorldType$selectInitialWorldType(state);
        if (ClientConfig.getKey() == WorldPresets.FLAT) {
            WorldCreationUiStateMixin.defaultWorldType$setFlatSettings(state);
        }
        if (ClientConfig.getKey() == WorldPresets.SINGLE_BIOME_SURFACE) {
            WorldCreationUiStateMixin.defaultWorldType$setSingleBiome(state);
        }
    }

    @Unique
    private static void defaultWorldType$writeRegistryToFile(Registry<?> registry, String registryName) {
        List<Identifier> ids = registry.entrySet().stream().map(Map.Entry::getKey).map(ResourceKey::identifier).sorted().toList();
        String content = ids.size() + " possible " + registryName + " found:\n" + ids.stream().map(loc -> "- \"" + String.valueOf(loc) + "\"").collect(Collectors.joining("\n"));
        try {
            Files.writeString(ClientConfig.CONFIG_PATH.resolve(registryName + ".txt"), (CharSequence)content, new OpenOption[0]);
        }
        catch (IOException ex) {
            DefaultWorldType.LOGGER.error("Couldn't generate file with existing {}", (Object)registryName, (Object)ex);
        }
    }

    @Unique
    private static List<WorldCreationUiState.WorldTypeEntry> defaultWorldType$buildPreferredPresetEntries(Registry<WorldPreset> registry) {
        ArrayList<WorldCreationUiState.WorldTypeEntry> result = new ArrayList<WorldCreationUiState.WorldTypeEntry>();
        for (String s : (List)ClientConfig.allowedWorldTypes.get()) {
            Identifier id = Identifier.parse((String)s);
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.WORLD_PRESET, (Identifier)id);
            registry.get(key).ifPresentOrElse(holder -> result.add(new WorldCreationUiState.WorldTypeEntry((Holder)holder)), () -> DefaultWorldType.LOGGER.warn("World preset \"{}\" not found", (Object)id));
        }
        return result;
    }

    @Unique
    private static void defaultWorldType$selectInitialWorldType(WorldCreationUiState state) {
        Optional<ResourceKey<WorldPreset>> configuredKey = Optional.of(ClientConfig.getKey());
        WorldCreationUiState.WorldTypeEntry entry = WorldCreationUiState.findPreset((WorldCreationContext)state.getSettings(), configuredKey).map(WorldCreationUiState.WorldTypeEntry::new).orElse((WorldCreationUiState.WorldTypeEntry)state.normalPresetList.getFirst());
        state.setWorldType(entry);
    }

    @Unique
    private static void defaultWorldType$setFlatSettings(WorldCreationUiState state) {
        state.updateDimensions((registry, worldDimensions) -> {
            WorldCreationContext settings = state.getSettings();
            Registry block = settings.worldgenLoadContext().lookupOrThrow(Registries.BLOCK);
            Registry biome = settings.worldgenLoadContext().lookupOrThrow(Registries.BIOME);
            Registry structureSet = settings.worldgenLoadContext().lookupOrThrow(Registries.STRUCTURE_SET);
            Registry placedFeature = settings.worldgenLoadContext().lookupOrThrow(Registries.PLACED_FEATURE);
            FlatLevelSource flatLevelSource = new FlatLevelSource(PresetFlatWorldScreen.fromString((HolderGetter)block, (HolderGetter)biome, (HolderGetter)structureSet, (HolderGetter)placedFeature, (String)((String)ClientConfig.flatMapSettings.get()), (FlatLevelGeneratorSettings)FlatLevelGeneratorSettings.getDefault((HolderGetter)biome, (HolderGetter)structureSet, (HolderGetter)placedFeature)));
            return worldDimensions.replaceOverworldGenerator((HolderLookup.Provider)registry, (ChunkGenerator)flatLevelSource);
        });
    }

    @Unique
    private static void defaultWorldType$setSingleBiome(WorldCreationUiState state) {
        state.updateDimensions((registry, worldDimensions) -> {
            WorldCreationContext settings = state.getSettings();
            Registry biomes = settings.worldgenLoadContext().lookupOrThrow(Registries.BIOME);
            Registry noiseGeneratorSettings = settings.worldgenLoadContext().lookupOrThrow(Registries.NOISE_SETTINGS);
            Holder.Reference biomeReference = biomes.get(ClientConfig.getFixedBiome()).orElseGet(() -> biomes.getOrThrow(Biomes.PLAINS));
            FixedBiomeSource fixedBiomeSource = new FixedBiomeSource((Holder)biomeReference);
            NoiseBasedChunkGenerator noiseBasedChunkGenerator = new NoiseBasedChunkGenerator((BiomeSource)fixedBiomeSource, (Holder)noiseGeneratorSettings.getOrThrow(NoiseGeneratorSettings.OVERWORLD));
            return worldDimensions.replaceOverworldGenerator((HolderLookup.Provider)registry, (ChunkGenerator)noiseBasedChunkGenerator);
        });
    }
}

