/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.defaultworldtype.mixin;

import de.melanx.defaultworldtype.ClientConfig;
import de.melanx.defaultworldtype.DefaultWorldType;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screens.PresetFlatWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.client.gui.screens.worldselection.WorldCreationUiState;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldCreationUiState.class})
public abstract class WorldCreationUiStateMixin {
    @Inject(method={"updatePresetLists"}, at={@At(value="TAIL")})
    private void afterUpdatePresetLists(CallbackInfo ci) {
        WorldCreationUiState state = (WorldCreationUiState)this;
        Registry worldPresets = state.m_267573_().m_246480_().m_175515_(Registries.f_256729_);
        Registry biomes = state.m_267573_().m_246480_().m_175515_(Registries.f_256952_);
        WorldCreationUiStateMixin.defaultWorldType$writeRegistryToFile(worldPresets, "world-presets");
        WorldCreationUiStateMixin.defaultWorldType$writeRegistryToFile(biomes, "biomes");
        List<WorldCreationUiState.WorldTypeEntry> preferredPresets = WorldCreationUiStateMixin.defaultWorldType$buildPreferredPresetEntries((Registry<WorldPreset>)worldPresets);
        if (!preferredPresets.isEmpty()) {
            state.f_267439_.clear();
            state.f_267439_.addAll(preferredPresets);
        }
        WorldCreationUiStateMixin.defaultWorldType$selectInitialWorldType(state);
        if (ClientConfig.getKey() == WorldPresets.f_226438_) {
            WorldCreationUiStateMixin.defaultWorldType$setFlatSettings(state);
        }
        if (ClientConfig.getKey() == WorldPresets.f_226441_) {
            WorldCreationUiStateMixin.defaultWorldType$setSingleBiome(state);
        }
    }

    @Unique
    private static void defaultWorldType$writeRegistryToFile(Registry<?> registry, String registryName) {
        List<ResourceLocation> ids = registry.m_6579_().stream().map(Map.Entry::getKey).map(ResourceKey::m_135782_).sorted().toList();
        String content = ids.size() + " possible " + registryName + " found:\n" + ids.stream().map(loc -> "- \"" + loc + "\"").collect(Collectors.joining("\n"));
        try {
            Files.writeString(ClientConfig.CONFIG_PATH.resolve(registryName + ".txt"), (CharSequence)content, new OpenOption[0]);
        }
        catch (IOException ex) {
            DefaultWorldType.LOGGER.error("Couldn't generate file with existing {}", (Object)registryName, (Object)ex);
        }
    }

    @Unique
    private static List<WorldCreationUiState.WorldTypeEntry> defaultWorldType$buildPreferredPresetEntries(Registry<WorldPreset> registry) {
        ArrayList<WorldCreationUiState.WorldTypeEntry> result = new ArrayList<WorldCreationUiState.WorldTypeEntry>();
        for (String s : (List)ClientConfig.allowedWorldTypes.get()) {
            ResourceLocation id = ResourceLocation.m_135820_((String)s);
            if (id == null) {
                DefaultWorldType.LOGGER.warn("Invalid world preset id \"{}\"", (Object)s);
                continue;
            }
            ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256729_, (ResourceLocation)id);
            registry.m_203636_(key).ifPresentOrElse(holder -> result.add(new WorldCreationUiState.WorldTypeEntry((Holder)holder)), () -> DefaultWorldType.LOGGER.warn("World preset \"{}\" not found", (Object)id));
        }
        return result;
    }

    @Unique
    private static void defaultWorldType$selectInitialWorldType(WorldCreationUiState state) {
        Optional<ResourceKey<WorldPreset>> configuredKey = Optional.of(ClientConfig.getKey());
        WorldCreationUiState.WorldTypeEntry entry = WorldCreationUiState.m_267777_((WorldCreationContext)state.m_267573_(), configuredKey).map(WorldCreationUiState.WorldTypeEntry::new).orElse((WorldCreationUiState.WorldTypeEntry)state.f_267439_.get(0));
        state.m_267576_(entry);
    }

    @Unique
    private static void defaultWorldType$setFlatSettings(WorldCreationUiState state) {
        state.m_267717_((registry, worldDimensions) -> {
            WorldCreationContext settings = state.m_267573_();
            HolderLookup.RegistryLookup block = settings.m_246480_().m_255025_(Registries.f_256747_);
            HolderLookup.RegistryLookup biome = settings.m_246480_().m_255025_(Registries.f_256952_);
            HolderLookup.RegistryLookup structureSet = settings.m_246480_().m_255025_(Registries.f_256998_);
            HolderLookup.RegistryLookup placedFeature = settings.m_246480_().m_255025_(Registries.f_256988_);
            FlatLevelSource flatLevelSource = new FlatLevelSource(PresetFlatWorldScreen.m_257717_((HolderGetter)block, (HolderGetter)biome, (HolderGetter)structureSet, (HolderGetter)placedFeature, (String)((String)ClientConfig.flatMapSettings.get()), (FlatLevelGeneratorSettings)FlatLevelGeneratorSettings.m_254980_((HolderGetter)biome, (HolderGetter)structureSet, (HolderGetter)placedFeature)));
            return worldDimensions.m_246747_((RegistryAccess)registry, (ChunkGenerator)flatLevelSource);
        });
    }

    @Unique
    private static void defaultWorldType$setSingleBiome(WorldCreationUiState state) {
        state.m_267717_((registry, worldDimensions) -> {
            WorldCreationContext settings = state.m_267573_();
            Registry biomes = settings.m_246480_().m_175515_(Registries.f_256952_);
            Registry noiseGeneratorSettings = settings.m_246480_().m_175515_(Registries.f_256932_);
            Holder.Reference biomeReference = biomes.m_203636_(ClientConfig.getFixedBiome()).orElseGet(() -> biomes.m_246971_(Biomes.f_48202_));
            FixedBiomeSource fixedBiomeSource = new FixedBiomeSource((Holder)biomeReference);
            NoiseBasedChunkGenerator noiseBasedChunkGenerator = new NoiseBasedChunkGenerator((BiomeSource)fixedBiomeSource, (Holder)noiseGeneratorSettings.m_246971_(NoiseGeneratorSettings.f_64432_));
            return worldDimensions.m_246747_((RegistryAccess)registry, (ChunkGenerator)noiseBasedChunkGenerator);
        });
    }
}

